<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class UpdateCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'install:update';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Ejecutar actualización del sistema';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $this->call('down');

        $this->info('Paso 1 de 3  - Ejecutando migraciones');
        $this->call('tenancy:migrate');
        //$this->call('migrate');

        $this->info('Paso 2 de 3 - Actualizando datos en la base de datos');
        //$this->call('db:seed', ['--force' => true]);

        $this->info('Paso 3 de 3 - Actualiza cache');
        $this->call('route:clear');
        $this->call('cache:clear');
        $this->call('config:clear');
        $this->call('view:clear');

        $this->call('up');
        $this->info('Actualización completada exitosamente');

        return true;
    }
}
