<?php

namespace App\Console;

use App\Helpers\Helper;
use App\Jobs\ProcessRecurringCustomerInvoice;
use App\Models\Base\BlackListSat;
use App\Models\Sales\RecurringCustomerInvoice;
use App\Models\System\SysCustomer;
use Hyn\Tenancy\Environment;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Illuminate\Support\Str;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        //
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // $schedule->command('inspire')
        //          ->hourly();

        //Ejecucion de facturas recurrentes todos los dias las 4:00 AM
        $schedule->call(function () {

            //Recorremos todos los clientes
            $sys_customers = SysCustomer::active()->whereNotNull('website_id')->get();
            if($sys_customers->isNotEmpty()) {
                foreach ($sys_customers as $sys_customer) {
                    $website = $sys_customer->website;
                    //Cambiamos entorno al del cliente
                    app(Environment::class)->tenant($website);

                    //Consultamos solo las facturas que se ejecutan este dia
                    $recurring_customer_invoices = RecurringCustomerInvoice::where('status', '=', '1')
                        ->whereDate('date_next', '=', Helper::dateToSql(\Date::today()))
                        ->whereDate('date_start', '<=', Helper::dateToSql(\Date::today()))
                        ->where(function ($query) {
                            $query->whereDate('date_end', '>=', Helper::dateToSql(\Date::today()));
                            $query->orWhereNull('date_end');
                        })
                        ->get();
                    if ($recurring_customer_invoices->isNotEmpty()) {
                        foreach ($recurring_customer_invoices as $recurring_customer_invoice) {
                            //Ejecuta trabajo
                            ProcessRecurringCustomerInvoice::dispatch($recurring_customer_invoice, $website);
                        }
                    }
                }
            }
        })->dailyAt('04:00');


        //Actualizacion de lista negra del SAT semanal
        $schedule->call(function () {
            try {
                //
                $path_temp = \Storage::path('temp/');

                //Consulta archivo
                $result = file_get_contents('http://omawww.sat.gob.mx/cifras_sat/Documents/Listado_Completo_69-B.csv');

                //Gguarda archivo
                $file_csv = Str::random(40) . '.csv';
                \Storage::put('temp/' . $file_csv, $result);

                //Lee archivo y crea arreglo
                $lineNumber = 0;
                $rows = [];
                $count = 1;
                $count_row = 0;
                if (($handle = fopen($path_temp . $file_csv, 'r')) !== FALSE) {
                    while(($row=fgetcsv($handle,1000,',')) !== FALSE) {
                        $lineNumber++;
                        if($lineNumber < 4){
                            continue;
                        }
                        if($row[1] != 'XXXXXXXXXXXX') {
                            $rows[$count_row][] = [
                                'created_at' => \Date::now(),
                                'updated_at' => \Date::now(),
                                'name' => utf8_encode(str_replace(['"','“','”'],'',$row[2])),
                                'taxid' => utf8_encode($row[1]),
                                'website_publication_presumed_sat' =>  Helper::convertDateToSql(str_replace('/','-',$row[5])),
                                'status_sat' => utf8_encode($row[3]),
                            ];
                            $count++;
                            if($count > 300){
                                $count_row++;
                                $count=1;
                            }
                        }
                    }
                    fclose($handle);
                }

                //Borra todos los registros
                if(!empty($rows)){
                    BlackListSat::where('id','>',0)->delete();
                }

                //Inserta nuevos registros
                if(!empty($rows)) {
                    foreach($rows as $row) {
                        BlackListSat::insert($row);
                    }
                }

                //
            }catch(\Exception $e){
                \Log::error($e->getMessage());
            }
        })->weeklyOn(4, '05:00');

        //Limpieza de archivos
        $schedule->call(function () {
            Helper::deleteTempFiles();
        })->dailyAt('03:00');
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
