<?php

namespace App\Exports;

use App\Models\Base\EmployeeCategory;
use App\Models\Catalogs\Bank;
use App\Models\Catalogs\ContractType;
use App\Models\Catalogs\Country;
use App\Models\Catalogs\FrequencyPayment;
use App\Models\Catalogs\JobRiskClasse;
use App\Models\Catalogs\RecruitmentRegime;
use App\Models\Catalogs\State;
use App\Models\Catalogs\WorkdayType;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;

class BankMoveTemplate implements FromCollection, WithHeadings, ShouldAutoSize
{
    protected $import_results;

    public function __construct(Request $request,$import_results)
    {
        $this->request = $request;
        $this->import_results = $import_results;
    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        return collect($this->import_results);
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            __('base/bank_reconciliation.column_date'),
            __('base/bank_reconciliation.column_credit'),
            __('base/bank_reconciliation.column_debit'),
            __('base/bank_reconciliation.column_reference'),
            __('base/bank_reconciliation.column_currency_code'),
        ];
    }
}
