<?php

namespace App\Exports;

use App\Helpers\Helper;
use App\Models\Base\BankMove;
use App\Models\Base\BankMoveReconciled;
use App\Models\Base\BankReconciliation;
use App\Models\Base\BankReconciliationUnreconcile;
use App\Models\Base\CfdiDownload;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStrictNullComparison;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Events\BeforeExport;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class BankReconciliationsExport implements FromCollection, WithMapping, WithHeadings, WithColumnFormatting, ShouldAutoSize, WithTitle, WithStrictNullComparison, WithEvents
{
    protected $request;

    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        $data = [];
        //Cfdis conciliados
        $data [] = (object)[
            'date' => __('base/bank_reconciliation.text_cfdi_download_reconcile'),
            'type' => '',
            'cfdi_type' => '',
            'name' => '',
            'reference' => '',
            'currency_code' => '',
            'credit' => '',
            'debit' => '',
            'no_conciled' => ''
        ];
        $results = BankMoveReconciled::where('key','=',$this->request->key)->sortable(['reconciled_id'])
            ->get();
        if($results->isNotEmpty()){
            foreach($results as $result){
                $data [] = (object)[
                    'date' => \App\Helpers\Helper::date(\App\Helpers\Helper::createDateTimeFromSql($result->reconciled->date)),
                    'type' => $result->reconciled->type_name,
                    'cfdi_type' => $result->reconciled->cfdiType->name ?? '',
                    'name' => $result->reconciled->name,
                    'reference' => '',
                    'currency_code' => $result->reconciled->currency->code ?? '',
                    'credit' => ($result->reconciled->type == '2' && $result->reconciled->cfdiType->code == 'I') ? $result->reconciled->amount_total : '',
                    'debit' => ($result->reconciled->type == '1' && $result->reconciled->cfdiType->code == 'I') ? $result->reconciled->amount_total : '',
                    'no_conciled' => $result->bankReconciliationLine->sort_order,
                ];
            }
        }

        //
        $data [] = (object)[
            'date' => '',
            'type' => '',
            'cfdi_type' => '',
            'name' => '',
            'reference' => '',
            'currency_code' => '',
            'credit' => '',
            'debit' => '',
            'no_conciled' => ''
        ];

        //Movimientos de banco no conciliados
        $data [] = (object)[
            'date' => __('base/bank_reconciliation.text_bank_move_reconcile'),
            'type' => '',
            'cfdi_type' => '',
            'name' => '',
            'reference' => '',
            'currency_code' => '',
            'credit' => '',
            'debit' => '',
            'no_conciled' => ''
        ];
        $results = BankMoveReconciled::where('key','=',$this->request->key)->sortable(['bank_move_id'])
            ->get();
        if($results->isNotEmpty()){
            foreach($results as $result){
                $data [] = (object)[
                    'date' => \App\Helpers\Helper::date(\App\Helpers\Helper::createDateTimeFromSql($result->bankMove->date)),
                    'type' => '',
                    'cfdi_type' => '',
                    'name' => '',
                    'reference' => $result->bankMove->reference,
                    'currency_code' => $result->bankMove->currency->code ?? '',
                    'credit' => ($result->bankMove->amount >= 0) ? abs($result->bankMove->amount) : '',
                    'debit' => ($result->bankMove->amount < 0) ? abs($result->bankMove->amount) : '',
                    'no_conciled' => $result->bankReconciliationLine->sort_order,
                ];
            }
        }

        $data [] = (object)[
            'date' => '',
            'type' => '',
            'cfdi_type' => '',
            'name' => '',
            'reference' => '',
            'currency_code' => '',
            'credit' => '',
            'debit' => '',
            'no_conciled' => ''
        ];

        //Cfdis no conciliados
        $data [] = (object)[
            'date' => __('base/bank_reconciliation.text_cfdi_download_unreconcile'),
            'type' => '',
            'cfdi_type' => '',
            'name' => '',
            'reference' => '',
            'currency_code' => '',
            'credit' => '',
            'debit' => '',
            'no_conciled' => ''
        ];
        $results = BankReconciliationUnreconcile::where('key','=',$this->request->key)->sortable(['id'])
            ->get();
        if($results->isNotEmpty()){
            foreach($results as $result){
                $data [] = (object)[
                    'date' => \App\Helpers\Helper::date(\App\Helpers\Helper::createDateTimeFromSql($result->cfdiDownload->date)),
                    'type' => $result->cfdiDownload->type_name,
                    'cfdi_type' => $result->cfdiDownload->cfdiType->name ?? '',
                    'name' => $result->cfdiDownload->name,
                    'reference' => '',
                    'currency_code' => $result->cfdiDownload->currency->code ?? '',
                    'credit' => ($result->cfdiDownload->type == '2' && $result->cfdiDownload->cfdiType->code == 'I') ? $result->cfdiDownload->amount_total : '',
                    'debit' => ($result->cfdiDownload->type == '1' && $result->cfdiDownload->cfdiType->code == 'I') ? $result->cfdiDownload->amount_total : '',
                    'no_conciled' => ''
                ];
            }
        }

        //
        $data [] = (object)[
            'date' => '',
            'type' => '',
            'cfdi_type' => '',
            'name' => '',
            'reference' => '',
            'currency_code' => '',
            'credit' => '',
            'debit' => '',
            'no_conciled' => ''
        ];

        //Movimientos de banco no conciliados
        $data [] = (object)[
            'date' => __('base/bank_reconciliation.text_bank_move_unreconcile'),
            'type' => '',
            'cfdi_type' => '',
            'name' => '',
            'reference' => '',
            'currency_code' => '',
            'credit' => '',
            'debit' => '',
            'no_conciled' => ''
        ];
        $results = BankMove::where('key','=',$this->request->key)->where('conciled','=',FALSE)->sortable(['id'])
            ->get();
        if($results->isNotEmpty()){
            foreach($results as $result){
                $data [] = (object)[
                    'date' => \App\Helpers\Helper::date(\App\Helpers\Helper::createDateTimeFromSql($result->date)),
                    'type' => '',
                    'cfdi_type' => '',
                    'name' => '',
                    'reference' => $result->reference,
                    'currency_code' => $result->currency->code ?? '',
                    'credit' => ($result->amount >= 0) ? abs($result->amount) : '',
                    'debit' => ($result->amount < 0) ? abs($result->amount) : '',
                    'no_conciled' => ''
                ];
            }
        }

        return collect($data);
    }

    /**
     * @return string
     */
    public function title(): string
    {
        return __('base/bank_reconciliation.text_movs');
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            __('base/bank_reconciliation.column_date'),
            __('base/bank_reconciliation.column_type'),
            __('base/bank_reconciliation.column_cfdi_type'),
            __('base/bank_reconciliation.column_name'),
            __('base/bank_reconciliation.column_reference'),
            __('base/bank_reconciliation.column_currency_code'),
            __('base/bank_reconciliation.column_credit'),
            __('base/bank_reconciliation.column_debit'),
            __('base/bank_reconciliation.column_no_conciled'),
        ];
    }

    /**
     * @return array
     */
    public function map($row): array
    {
        return [
            $row->date,
            $row->type,
            $row->cfdi_type,
            $row->name,
            $row->reference,
            $row->currency_code,
            $row->credit,
            $row->debit,
            $row->no_conciled,
        ];
    }

    /**
     * @return array
     */
    public function columnFormats(): array
    {
        return [
            'G' => NumberFormat::FORMAT_CURRENCY_USD_SIMPLE,
            'H' => NumberFormat::FORMAT_CURRENCY_USD_SIMPLE,
        ];
    }

    /**
     * @return array
     */
    public function registerEvents(): array
    {
        return [
            BeforeExport::class => function (BeforeExport $event) {
                $event->getWriter()->getDelegate()
                    ->getProperties()
                    ->setCreator(config('app.name'))
                    ->setLastModifiedBy(config('app.name'))
                    ->setTitle(__('base/bank_reconciliation.text_bank_reconliations_unreconcile') . '-' . config('app.name'))
                    ->setDescription(
                        __('base/bank_reconciliation.text_bank_reconliations_unreconcile') . '-' . config('app.name')
                    );
            },
            // Array callable, refering to a static method.
            AfterSheet::class => [self::class, 'afterSheet'],

        ];
    }

    public static function AfterSheet(AfterSheet $event)
    {

        //Default

        //Titulo
        $title_cell_range = 'A1:I1';
        $title_style = [
            'alignment' => [
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ],
            'font' => [
                'name' => 'Arial',
                'size' => 10,
                'bold' => true,
                'color' => ['argb' => '0A7864'],
            ],
            'borders' => [
                'bottom' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_MEDIUM,
                    'color' => ['argb' => 'C5DAD6'],
                ],
            ]
        ];
        $event->getDelegate()->getStyle($title_cell_range)->applyFromArray($title_style);
        $event->getDelegate()->getStyle($title_cell_range)->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()->setARGB('EEEEEE');
        $event->getDelegate()->getRowDimension('1')->setRowHeight(22);
        //$event->getDelegate()->getColumnDimension('B')->setWidth(50);

        //Ajuste otras columnas
        $style_center = [
            'alignment' => [
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
            ],
        ];
        $style_right = [
            'alignment' => [
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
            ],
        ];
        $event->getDelegate()->getStyle('A2:A1000')->applyFromArray($style_center);
        $event->getDelegate()->getStyle('B2:B1000')->applyFromArray($style_center);
        $event->getDelegate()->getStyle('C2:C1000')->applyFromArray($style_center);
        $event->getDelegate()->getStyle('F2:F1000')->applyFromArray($style_center);
        $event->getDelegate()->getStyle('I2:I1000')->applyFromArray($style_center);

    }
}
