<?php

namespace App\Exports;

use App\Helpers\Helper;
use App\Models\Base\CfdiDownload;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStrictNullComparison;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Events\BeforeExport;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class CfdiDownloadsCustomerPaymentExport implements FromCollection, WithMapping, WithHeadings, WithColumnFormatting, ShouldAutoSize, WithTitle, WithStrictNullComparison, WithEvents
{
    protected $rows;

    public function __construct($rows)
    {
        $this->rows = $rows;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return $this->rows;
    }

    /**
     * @return string
     */
    public function title(): string
    {
        return __('base/cfdi_download.document_title');
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            __('base/cfdi_download.column_type'),
            __('base/cfdi_download.column_cfdi_type'),
            __('base/cfdi_download.column_serie'),
            __('base/cfdi_download.column_folio'),
            __('base/cfdi_download.column_date'),
            __('base/cfdi_download.column_time'),
            __('base/cfdi_download.column_uuid'),
            __('base/cfdi_download.column_rfc_emisor'),
            __('base/cfdi_download.column_emisor'),
            __('base/cfdi_download.column_rfc_receptor'),
            __('base/cfdi_download.column_receptor'),
            __('base/cfdi_download.column_payment_way'),
            __('base/cfdi_download.column_payment_method'),
            __('base/cfdi_download.column_cfdi_use'),
            __('base/cfdi_download.column_currency'),
            __('base/cfdi_download.column_currency_value'),
            __('base/cfdi_download.column_amount_untaxed'),
            __('base/cfdi_download.column_amount_discount'),
            #__('base/cfdi_download.column_amount_iva'),
            __('base/cfdi_download.column_amount_iva_16'),
            __('base/cfdi_download.column_amount_iva_15'),
            __('base/cfdi_download.column_amount_iva_11'),
            __('base/cfdi_download.column_amount_iva_10'),
            __('base/cfdi_download.column_amount_iva_8'),
            __('base/cfdi_download.column_amount_ieps'),
            __('base/cfdi_download.column_amount_tax'),
            __('base/cfdi_download.column_amount_ret_iva'),
            __('base/cfdi_download.column_amount_ret_isr'),
            __('base/cfdi_download.column_amount_tax_ret'),
            __('base/cfdi_download.column_amount_total'),
            __('base/cfdi_download.column_balance'),
            __('base/cfdi_download.column_rfc_pac'),
            __('base/cfdi_download.column_status'),
            __('base/cfdi_download.column_is_cancelable'),
            __('base/cfdi_download.column_expense_type'),
            __('base/cfdi_download.column_operational_type'),
            __('base/cfdi_download.column_comment_0'),
            __('base/cfdi_download.column_comment_2'),

            __('base/cfdi_download.column_reconciled_uuid'),
            __('base/cfdi_download.column_reconciled_serie'),
            __('base/cfdi_download.column_reconciled_serie'),
            __('base/cfdi_download.column_reconciled_currency'),
            __('base/cfdi_download.column_reconciled_currency_value2'),
            __('base/cfdi_download.column_reconciled_number_of_payment'),
            __('base/cfdi_download.column_reconciled_last_balance'),
            __('base/cfdi_download.column_reconciled_amount_reconciled2'),
            __('base/cfdi_download.column_reconciled_currenct_balance'),
        ];
    }

    /**
     * @return array
     */
    public function map($row): array
    {
        return $row;
    }

    /**
     * @return array
     */
    public function columnFormats(): array
    {
        return [
            'P' => '"$"#,##0.0000_-',
            'Q' => NumberFormat::FORMAT_CURRENCY_USD_SIMPLE,
            'R' => NumberFormat::FORMAT_CURRENCY_USD_SIMPLE,
            'S' => NumberFormat::FORMAT_CURRENCY_USD_SIMPLE,
            'T' => NumberFormat::FORMAT_CURRENCY_USD_SIMPLE,
            'U' => NumberFormat::FORMAT_CURRENCY_USD_SIMPLE,
            'V' => NumberFormat::FORMAT_CURRENCY_USD_SIMPLE,
            'W' => NumberFormat::FORMAT_CURRENCY_USD_SIMPLE,
            'X' => NumberFormat::FORMAT_CURRENCY_USD_SIMPLE,
            'Y' => NumberFormat::FORMAT_CURRENCY_USD_SIMPLE,
            'Z' => NumberFormat::FORMAT_CURRENCY_USD_SIMPLE,
            'AA' => NumberFormat::FORMAT_CURRENCY_USD_SIMPLE,
            'AB' => NumberFormat::FORMAT_CURRENCY_USD_SIMPLE,
            'AC' => NumberFormat::FORMAT_CURRENCY_USD_SIMPLE,
            'AD' => NumberFormat::FORMAT_CURRENCY_USD_SIMPLE,
            'AP' => '"$"#,##0.0000_-',
            'AR' => NumberFormat::FORMAT_CURRENCY_USD_SIMPLE,
            'AS' => NumberFormat::FORMAT_CURRENCY_USD_SIMPLE,
            'AT' => NumberFormat::FORMAT_CURRENCY_USD_SIMPLE,
        ];
    }

    /**
     * @return array
     */
    public function registerEvents(): array
    {
        return [
            BeforeExport::class => function (BeforeExport $event) {
                $event->getWriter()->getDelegate()
                    ->getProperties()
                    ->setCreator(config('app.name'))
                    ->setLastModifiedBy(config('app.name'))
                    ->setTitle(__('base/cfdi_download.document_title') . '-' . config('app.name'))
                    ->setDescription(
                        __('base/cfdi_download.document_title') . '-' . config('app.name')
                    );
            },
            // Array callable, refering to a static method.
            AfterSheet::class => [self::class, 'afterSheet'],

        ];
    }

    public static function AfterSheet(AfterSheet $event)
    {

        //Default

        //Titulo
        $title_cell_range = 'A1:AT1';
        $title_style = [
            'alignment' => [
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ],
            'font' => [
                'name' => 'Arial',
                'size' => 10,
                'bold' => true,
                'color' => ['argb' => '0A7864'],
            ],
            'borders' => [
                'bottom' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_MEDIUM,
                    'color' => ['argb' => 'C5DAD6'],
                ],
            ]
        ];
        $event->getDelegate()->getStyle($title_cell_range)->applyFromArray($title_style);
        $event->getDelegate()->getStyle($title_cell_range)->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()->setARGB('EEEEEE');
        $event->getDelegate()->getRowDimension('1')->setRowHeight(22);
        //$event->getDelegate()->getColumnDimension('B')->setWidth(50);

        //autosize
        foreach(range('A','Z') as $columnID) {
            $event->getDelegate()->getColumnDimension($columnID)->setAutoSize(true);
        }
        foreach(range('A','A') as $columnID) {
            foreach(range('A','T') as $columnID2) {
                $event->getDelegate()->getColumnDimension($columnID . $columnID2)->setAutoSize(true);
            }
        }

        //Ajuste otras columnas
        $style_center = [
            'alignment' => [
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
            ],
        ];
        $style_right = [
            'alignment' => [
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
            ],
        ];
        $event->getDelegate()->getStyle('A2:A1000')->applyFromArray($style_center);
        $event->getDelegate()->getStyle('B2:B1000')->applyFromArray($style_center);
        $event->getDelegate()->getStyle('C2:C1000')->applyFromArray($style_center);
        $event->getDelegate()->getStyle('D2:D1000')->applyFromArray($style_center);
        $event->getDelegate()->getStyle('E2:E1000')->applyFromArray($style_center);
        $event->getDelegate()->getStyle('F2:F1000')->applyFromArray($style_center);
        $event->getDelegate()->getStyle('G2:G1000')->applyFromArray($style_center);
        $event->getDelegate()->getStyle('H2:H1000')->applyFromArray($style_center);
        //I
        $event->getDelegate()->getStyle('J2:J1000')->applyFromArray($style_center);
        //K
        //L
        //M
        //N
        $event->getDelegate()->getStyle('O2:O1000')->applyFromArray($style_center);
        $event->getDelegate()->getStyle('Z2:Z1000')->applyFromArray($style_center);
        $event->getDelegate()->getStyle('AA2:AA1000')->applyFromArray($style_center);

        $event->getDelegate()->getStyle('AL2:AL1000')->applyFromArray($style_center);
        $event->getDelegate()->getStyle('AM2:AM1000')->applyFromArray($style_center);
        $event->getDelegate()->getStyle('AN2:AN1000')->applyFromArray($style_center);
        $event->getDelegate()->getStyle('AO2:AO1000')->applyFromArray($style_center);
        $event->getDelegate()->getStyle('AQ2:AQ1000')->applyFromArray($style_center);


    }
}
