<?php

namespace App\Exports;

use App\Models\Catalogs\Tax;
use Illuminate\Http\Request;
use App\Models\Catalogs\CfdiUse;
use App\Models\Catalogs\Product;
use App\Models\Base\BranchOffice;
use App\Models\Sales\Salesperson;
use App\Models\Catalogs\PaymentWay;
use App\Models\Catalogs\SatProduct;
use App\Models\Catalogs\PaymentTerm;
use App\Models\Catalogs\UnitMeasure;
use App\Models\Catalogs\CfdiRelation;
use App\Models\Catalogs\PaymentMethod;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\FromCollection;

class CustomerCreditNoteTemplateImportExport implements FromCollection, WithHeadings
{
    protected $request;
    protected $customers;

    public function __construct(Request $request,$customers)
    {
        $this->request = $request;
        $this->customers = $customers;
    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $customers = $this->customers;
        $results = [];
        $branch_office = null;
        if(!empty($this->request->branch_office_id)){
            $branch_office = BranchOffice::findOrFail($this->request->branch_office_id);
        }
        $payment_term = null;
        if(!empty($this->request->payment_term_id)){
            $payment_term = PaymentTerm::findOrFail($this->request->payment_term_id);
        }
        $salesperson = null;
        if(!empty($this->request->salesperson_id)){
            $salesperson = Salesperson::findOrFail($this->request->salesperson_id);
        }
        $payment_way = null;
        if(!empty($this->request->payment_way_id)){
            $payment_way = PaymentWay::findOrFail($this->request->payment_way_id);
        }
        $payment_method = null;
        if(!empty($this->request->payment_method_id)){
            $payment_method = PaymentMethod::findOrFail($this->request->payment_method_id);
        }
        $cfdi_use = null;
        if(!empty($this->request->cfdi_use_id)){
            $cfdi_use = CfdiUse::findOrFail($this->request->cfdi_use_id);
        }
        $cfdi_relation = null;
        if(!empty($this->request->cfdi_relation_id)){
            $cfdi_relation = CfdiRelation::findOrFail($this->request->cfdi_relation_id);
        }
        $product = null;
        if(!empty($this->request->product_id)){
            $product = Product::findOrFail($this->request->product_id);
        }
        $unit_measure = null;
        if(!empty($this->request->unit_measure_id)){
            $unit_measure = UnitMeasure::findOrFail($this->request->unit_measure_id);
        }
        $sat_product = null;
        if(!empty($this->request->sat_product_id)){
            $sat_product = SatProduct::findOrFail($this->request->sat_product_id);
        }
        $taxes = null;
        $taxes_str = '';
        if(!empty($this->request->taxes)){
            $taxes = $this->request->taxes;
            $taxes_tmp = [];
            for($i = 0; $i < count($taxes); $i++){
                $tax = Tax::findOrFail($taxes[$i]);
                array_push($taxes_tmp,$tax->name);
            }
            if(!empty($taxes_tmp)){
                $taxes_str = join(', ', $taxes_tmp);
            }
        }
        $count = 1;
        foreach($customers as $customer){
            $results [] = [
                'customer_taxid' => $customer->taxid,
                'customer' => $customer->name,
                'branch_office' => $branch_office->name ?? '',
                'currency' => 'MXN',
                'payment_term' => $payment_term->name ?? '',
                'salesperson' => $salesperson->name ?? '',
                'payment_way' => $payment_way->name ?? '',
                'payment_method' => $payment_method->code ?? '',
                'cfdi_use' => $cfdi_use->name ?? '',
                'cfdi_relation' => $cfdi_relation->name ?? '',
                'uuids' => '',
                'quantity' => $this->request->quantity,
                'product' => $product->code ?? '',
                'name' => $this->request->name,
                'unit_measure' => !empty($unit_measure) ? $unit_measure->code . '-' .$unit_measure->name : '',
                'sat_product' => $sat_product->code ?? '',
                'price_unit' => $this->request->price_unit ?? '',
                'includes_iva' => !empty($this->request->includes_iva) ? 'S' : 'N',
                'taxes' => $taxes_str ?? '',
                'send_mail' => 'N',
            ];
            if($count > 100){
                break;
            }
            $count++;
        }

        return collect($results);
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            __('sales/customer.entry_taxid2'),
            __('sales/customer.text_customer'),
            __('sales/customer_credit_note.entry_branch_office_id'),
            __('sales/customer_credit_note.entry_currency_id'),
            __('sales/customer_credit_note.entry_payment_term_id'),
            __('sales/customer_credit_note.entry_salesperson_id'),
            __('sales/customer_credit_note.entry_payment_way_id'),
            __('sales/customer_credit_note.entry_payment_method_id'),
            __('sales/customer_credit_note.entry_cfdi_use_id'),
            __('sales/customer_credit_note.entry_cfdi_relation_id'),
            __('sales/customer_credit_note.entry_uuids'),
            __('sales/customer_credit_note.column_line_quantity'),
            __('sales/customer_credit_note.column_line_product_id'),
            __('sales/customer_credit_note.column_line_name'),
            __('sales/customer_credit_note.column_line_unit_measure_id'),
            __('sales/customer_credit_note.column_line_sat_product_id'),
            __('sales/customer_credit_note.column_line_price_unit'),
            __('sales/customer_credit_note.text_includes_iva'),
            __('sales/customer_credit_note.column_line_taxes'),
            __('sales/customer_credit_note.column_line_send_mail'),
        ];
    }
}
