<?php

namespace App\Exports;

use Illuminate\Http\Request;
use App\Models\Base\BranchOffice;
use App\Models\Catalogs\PaymentWay;
use App\Models\Catalogs\CfdiRelation;
use App\Models\Base\CompanyBankAccount;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\FromCollection;

class CustomerPaymentTemplateImportExport implements FromCollection, WithHeadings
{
    protected $request;
    protected $customers;

    public function __construct(Request $request,$customers)
    {
        $this->request = $request;
        $this->customers = $customers;
    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $customers = $this->customers;
        $results = [];
        $branch_office = null;
        if(!empty($this->request->branch_office_id)){
            $branch_office = BranchOffice::findOrFail($this->request->branch_office_id);
        }
        $payment_way = null;
        if(!empty($this->request->payment_way_id)){
            $payment_way = PaymentWay::findOrFail($this->request->payment_way_id);
        }
        $cfdi_relation = null;
        if(!empty($this->request->cfdi_relation_id)){
            $cfdi_relation = CfdiRelation::findOrFail($this->request->cfdi_relation_id);
        }
        $company_bank_account = null;
        if(!empty($this->request->company_bank_account_id)){
            $company_bank_account = CompanyBankAccount::findOrFail($this->request->company_bank_account_id);
        }
        $count = 1;
        foreach($customers as $customer){
            $results [] = [
                'customer_taxid' => $customer->taxid,
                'customer' => $customer->name,
                'branch_office' => $branch_office->name ?? '',
                'currency' => 'MXN',
                'date_payment' => $this->request->date_payment,
                'payment_way' => $payment_way->name ?? '',
                'amount' => 0,
                'customer_bank_account' => '',
                'reference' => '',
                'company_bank_account' => $company_bank_account->name ?? '',
                'cfdi_relation' => $cfdi_relation->name ?? '',
                'uuids' => '',
                'reconciled_name' => '',
                'reconciled_currency_value' => '',
                'reconciled_amount_reconciled2' => '',
                'send_mail' => 'N',
            ];
            if($count > 100){
                break;
            }
            $count++;
        }

        return collect($results);
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            __('sales/customer.entry_taxid2'),
            __('sales/customer.text_customer'),
            __('sales/customer_payment.entry_branch_office_id'),
            __('sales/customer_payment.entry_currency_id'),
            __('sales/customer_payment.entry_date_payment'),
            __('sales/customer_payment.entry_payment_way_id'),
            __('sales/customer_payment.entry_amount'),
            __('sales/customer_payment.entry_customer_bank_account_id'),
            __('sales/customer_payment.entry_reference'),
            __('sales/customer_payment.entry_company_bank_account_id'),
            __('sales/customer_payment.entry_cfdi_relation_id'),
            __('sales/customer_payment.entry_uuids'),
            __('sales/customer_payment.column_reconciled_name'),
            __('sales/customer_payment.column_reconciled_currency_value'),
            __('sales/customer_payment.column_reconciled_amount_reconciled2'),
            __('sales/customer_payment.column_line_send_mail'),
        ];
    }
}
