<?php

namespace App\Exports;

use App\Models\Catalogs\CfdiUse;
use App\Models\Catalogs\City;
use App\Models\Catalogs\Country;
use App\Models\Catalogs\PaymentMethod;
use App\Models\Catalogs\PaymentTerm;
use App\Models\Catalogs\PaymentWay;
use App\Models\Catalogs\State;
use App\Models\Catalogs\TaxRegimen;
use App\Models\Sales\Salesperson;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class CustomerTemplateImportExport implements FromCollection, WithHeadings
{
    protected $import_results;

    public function __construct(Request $request,$import_results)
    {
        $this->request = $request;
        $this->import_results = $import_results;
    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        foreach($this->import_results as $key => $result){
            if(!empty($this->request->tax_regimen_id)){
                $tax_regimen = TaxRegimen::findOrFail($this->request->tax_regimen_id);
                if(!empty($tax_regimen)){
                    $this->import_results[$key]->tax_regimen = $tax_regimen->name;
                }
            }
            if(!empty($this->request->payment_term_id)){
                $payment_term = PaymentTerm::findOrFail($this->request->payment_term_id);
                if(!empty($payment_term)){
                    $this->import_results[$key]->payment_term = $payment_term->name;
                }
            }
            if(!empty($this->request->payment_way_id)){
                $payment_way = PaymentWay::findOrFail($this->request->payment_way_id);
                if(!empty($payment_way)){
                    $this->import_results[$key]->payment_way = $payment_way->name;
                }
            }
            if(!empty($this->request->payment_method_id)){
                $payment_method = PaymentMethod::findOrFail($this->request->payment_method_id);
                if(!empty($payment_method)){
                    $this->import_results[$key]->payment_method = $payment_method->code;
                }
            }
            if(!empty($this->request->cfdi_use_id)){
                $cfdi_use = CfdiUse::findOrFail($this->request->cfdi_use_id);
                if(!empty($cfdi_use)){
                    $this->import_results[$key]->cfdi_use = $cfdi_use->name;
                }
            }
            if(!empty($this->request->salesperson_id)){
                $salesperson = Salesperson::findOrFail($this->request->salesperson_id);
                if(!empty($salesperson)){
                    $this->import_results[$key]->salesperson = $salesperson->name;
                }
            }
            if(!empty($this->request->country_id)){
                $country = Country::findOrFail($this->request->country_id);
                if(!empty($country)){
                    $this->import_results[$key]->country = $country->name;
                }
            }
            if(!empty($this->request->state_id)){
                $state = State::findOrFail($this->request->state_id);
                if(!empty($state)){
                    $this->import_results[$key]->state = $state->name;
                }
            }
            if(!empty($this->request->city_id)){
                $city = City::findOrFail($this->request->city_id);
                if(!empty($city)){
                    $this->import_results[$key]->city = $city->name;
                }
            }

        }
        return collect($this->import_results);
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            __('sales/customer.entry_name'),
            __('sales/customer.entry_taxid'),
            __('sales/customer.entry_tax_regimen_id'),
            __('sales/customer.entry_payment_term_id'),
            __('sales/customer.entry_payment_way_id'),
            __('sales/customer.entry_payment_method_id'),
            __('sales/customer.entry_cfdi_use_id'),
            __('sales/customer.entry_salesperson_id'),
            __('sales/customer.entry_email'),
            __('sales/customer.entry_phone'),
            __('sales/customer.entry_address_1'),
            __('sales/customer.entry_address_2'),
            __('sales/customer.entry_address_3'),
            __('sales/customer.entry_address_4'),
            __('sales/customer.entry_country_id'),
            __('sales/customer.entry_state_id'),
            __('sales/customer.entry_city_id'),
            __('sales/customer.entry_postcode'),
        ];
    }
}
