<?php

namespace App\Exports;

use Illuminate\Http\Request;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\FromCollection;

class CustomerTransferTemplateTransferImportExport implements FromCollection, WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $results = [];
        $results [] = [
            'sat_product' => '50403200',
            'name' => 'Maíz delicia doble',
            'quantity' => '1',
            'unit_measure' => 'KGM-Kilogramo',
            'weight' => '400',
            'dangerous_product' => 'NO',
            'packaging_type' => '',
            'dangerous_product2' => '',
            'dimensions' => '',
            'amount_total' => '1',
            'currency' => 'MXN',
            'tariff_fraction' => '',
            'uuid_ext' => '',
            'petition' => ''
        ];
        $results [] = [
            'sat_product' => '12131500',
            'name' => '',
            'quantity' => '9',
            'unit_measure' => 'KGM-Kilogramo',
            'weight' => '9000',
            'dangerous_product' => 'SÍ',
            'packaging_type' => '5L3-Sacos (Bolsas) de Tela resistentes al agua',
            'dangerous_product2' => '0180-COHETES con carga explosiva',
            'dimensions' => '100/100/100cm',
            'amount_total' => '1',
            'currency' => 'MXN',
            'tariff_fraction' => '', //9301200100-Lanzacohetes; lanzallamas; lanzagranadas; lanzatorpedos y lanzadores similares.
            'uuid_ext' => '',
            'petition' => ''
        ];

        return collect($results);
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            __('sales/customer_transfer.column_line_transfer_sat_product_id'),
            __('sales/customer_transfer.column_line_transfer_name'),
            __('sales/customer_transfer.column_line_transfer_quantity'),
            __('sales/customer_transfer.column_line_transfer_unit_measure_id'),
            __('sales/customer_transfer.column_line_transfer_weight'),
            __('sales/customer_transfer.column_line_transfer_dangerous_product'),
            __('sales/customer_transfer.column_line_transfer_packaging_type_id'),
            __('sales/customer_transfer.column_line_transfer_dangerous_product_id'),
            __('sales/customer_transfer.column_line_transfer_dimensions'),
            __('sales/customer_transfer.column_line_transfer_amount_total'),
            __('sales/customer_transfer.column_line_transfer_currency_id'),
            __('sales/customer_transfer.column_line_transfer_tariff_fraction_id'),
            __('sales/customer_transfer.column_line_transfer_uuid_ext'),
            __('sales/customer_transfer.column_line_transfer_petition'),
        ];
    }
}
