<?php

namespace App\Exports;

use App\Models\Sales\Customer;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStrictNullComparison;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Events\BeforeExport;

class CustomersExport implements FromCollection, WithMapping, WithHeadings, WithColumnFormatting, ShouldAutoSize, WithTitle, WithStrictNullComparison, WithEvents
{
    protected $request;

    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return Customer::filter($this->request->all())->sortable('name')->get();
    }

    /**
     * @return string
     */
    public function title(): string
    {
        return __('sales/customer.document_title');
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            __('sales/customer.column_name'),
            __('sales/customer.column_taxid'),
            __('sales/customer.column_tax_regimen'),
            __('sales/customer.column_payment_term'),
            __('sales/customer.column_payment_way'),
            __('sales/customer.entry_payment_method_id'),
            __('sales/customer.column_cfdi_use'),
            __('sales/customer.column_salesperson'),
            __('sales/customer.column_email'),
            __('sales/customer.column_phone'),
            __('sales/customer.entry_address_1'),
            __('sales/customer.entry_address_2'),
            __('sales/customer.entry_address_3'),
            __('sales/customer.entry_address_4'),
            __('sales/customer.column_country'),
            __('sales/customer.entry_state_id'),
            __('sales/customer.entry_city_id'),
            __('sales/customer.column_postcode'),
        ];
    }

    /**
     * @return array
     */
    public function map($row): array
    {
        return [
            $row->name,
            $row->taxid,
            $row->taxRegimen->name ?? '',
            $row->paymentTerm->name ?? '',
            $row->paymentWay->name ?? '',
            $row->paymentMethod->code ?? '',
            $row->cfdiUse->name ?? '',
            $row->salesperson->name ?? '',
            $row->email,
            $row->phone,
            $row->address_1,
            $row->address_2,
            $row->address_3,
            $row->address_4,
            $row->country->name ?? '',
            $row->state->name ?? '',
            $row->city->name ?? '',
            $row->postcode,
        ];
    }

    /**
     * @return array
     */
    public function columnFormats(): array
    {
        return [

        ];
    }

    /**
     * @return array
     */
    public function registerEvents(): array
    {
        return [
            BeforeExport::class => function (BeforeExport $event) {
                $event->getWriter()->getDelegate()
                    ->getProperties()
                    ->setCreator(config('app.name'))
                    ->setLastModifiedBy(config('app.name'))
                    ->setTitle(__('sales/customer.document_title') . '-' . config('app.name'))
                    ->setDescription(
                        __('sales/customer.document_title') . '-' . config('app.name')
                    );
            },
            // Array callable, refering to a static method.
            AfterSheet::class => [self::class, 'afterSheet'],

        ];
    }

    public static function AfterSheet(AfterSheet $event)
    {

        //Default

        //Titulo
        $title_cell_range = 'A1:R1';
        $title_style = [
            'alignment' => [
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ],
            'font' => [
                'name' => 'Arial',
                'size' => 10,
                'bold' => true,
                'color' => ['argb' => '0A7864'],
            ],
            'borders' => [
                'bottom' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_MEDIUM,
                    'color' => ['argb' => 'C5DAD6'],
                ],
            ]
        ];
        $event->getDelegate()->getStyle($title_cell_range)->applyFromArray($title_style);
        $event->getDelegate()->getStyle($title_cell_range)->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()->setARGB('EEEEEE');
        $event->getDelegate()->getRowDimension('1')->setRowHeight(22);
        //$event->getDelegate()->getColumnDimension('A')->setWidth(50);

        //Ajuste otras columnas
        $style_center = [
            'alignment' => [
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
            ],
        ];
        $event->getDelegate()->getStyle('B2:B1000')->applyFromArray($style_center);

    }

}
