<?php

namespace App\Exports;

use Illuminate\Http\Request;
use App\Models\Catalogs\Bank;
use App\Models\Catalogs\State;
use App\Models\Catalogs\Country;
use App\Models\Catalogs\TaxRegimen;
use App\Models\Catalogs\WorkdayType;
use App\Models\Base\EmployeeCategory;
use App\Models\Catalogs\ContractType;
use App\Models\Catalogs\JobRiskClasse;
use App\Models\Catalogs\FrequencyPayment;
use App\Models\Catalogs\RecruitmentRegime;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\FromCollection;

class EmployeeTemplateImportExport implements FromCollection, WithHeadings
{
    protected $import_results;

    public function __construct(Request $request,$import_results)
    {
        $this->request = $request;
        $this->import_results = $import_results;
    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        foreach($this->import_results as $key => $result){
            if(!empty($this->request->tax_regimen_id)){
                $tax_regimen = TaxRegimen::findOrFail($this->request->tax_regimen_id);
                if(!empty($tax_regimen)){
                    $this->import_results[$key]->tax_regimen = $tax_regimen->name;
                }
            }
            if(!empty($this->request->recruitment_regime_id)){
                $recruitment_regime = RecruitmentRegime::findOrFail($this->request->recruitment_regime_id);
                if(!empty($recruitment_regime)){
                    $this->import_results[$key]->recruitment_regime = $recruitment_regime->name;
                }
            }
            if(!empty($this->request->unionized)){
                $this->import_results[$key]->unionized = 'S';
            }
            if(!empty($this->request->workday_type_id)){
                $workday_type = WorkdayType::findOrFail($this->request->workday_type_id);
                if(!empty($workday_type)){
                    $this->import_results[$key]->workday_type = $workday_type->name;
                }
            }
            if(!empty($this->request->contract_type_id)){
                $contract_type = ContractType::findOrFail($this->request->contract_type_id);
                if(!empty($contract_type)){
                    $this->import_results[$key]->contract_type = $contract_type->name;
                }
            }
            if(!empty($this->request->employee_category_id)){
                $employee_category = EmployeeCategory::findOrFail($this->request->employee_category_id);
                if(!empty($employee_category)){
                    $this->import_results[$key]->employee_category = $employee_category->name;
                }
            }
            if(!empty($this->request->department)){
                $this->import_results[$key]->department = $this->request->department;
            }
            if(!empty($this->request->job_risk_classe_id)){
                $job_risk_classe = JobRiskClasse::findOrFail($this->request->job_risk_classe_id);
                if(!empty($job_risk_classe)){
                    $this->import_results[$key]->job_risk_classe = $job_risk_classe->name;
                }
            }
            if(!empty($this->request->frequency_payment_id)){
                $frequency_payment = FrequencyPayment::findOrFail($this->request->frequency_payment_id);
                if(!empty($frequency_payment)){
                    $this->import_results[$key]->frequency_payment = $frequency_payment->name;
                }
            }
            if(!empty($this->request->bank_id)){
                $bank = Bank::findOrFail($this->request->bank_id);
                if(!empty($bank)){
                    $this->import_results[$key]->bank = $bank->name;
                }
            }
            if(!empty($this->request->base_salary)){
                $this->import_results[$key]->base_salary = $this->request->base_salary;
            }
            if(!empty($this->request->sdi)){
                $this->import_results[$key]->sdi = $this->request->sdi;
            }
            if(!empty($this->request->country_id)){
                $country = Country::findOrFail($this->request->country_id);
                if(!empty($country)){
                    $this->import_results[$key]->country = $country->name;
                }
            }
            if(!empty($this->request->state_id)){
                $state = State::findOrFail($this->request->state_id);
                if(!empty($state)){
                    $this->import_results[$key]->state = $state->name;
                }
            }

        }
        return collect($this->import_results);
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            __('base/employee.column_code'),
            __('base/employee.column_firstname'),
            __('base/employee.column_lastname'),
            __('base/employee.column_lastname2'),
            __('base/employee.column_taxid'),
            __('base/employee.column_tax_regimen'),
            __('base/employee.column_curp'),
            __('base/employee.column_postcode'),
            __('base/employee.column_nss'),
            __('base/employee.column_email'),
            __('base/employee.column_recruitment_regime'),
            __('base/employee.column_date_start_work'),
            __('base/employee.column_unionized'),
            __('base/employee.column_workday_type'),
            __('base/employee.column_contract_type'),
            __('base/employee.column_employee_category'),
            __('base/employee.column_department'),
            __('base/employee.column_job'),
            __('base/employee.column_job_risk_classe'),
            __('base/employee.column_frequency_payment'),
            __('base/employee.column_bank'),
            __('base/employee.column_bank_account'),
            __('base/employee.column_base_salary'),
            __('base/employee.column_sdi'),
            __('base/employee.column_country'),
            __('base/employee.column_state'),
        ];
    }
}
