<?php

namespace App\Exports;

use App\Helpers\Helper;
use App\Models\Base\BranchOffice;
use App\Models\Catalogs\PayrollType;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Illuminate\Http\Request;

class PayrollAssimilatedTemplateImportExport implements FromCollection, WithHeadings
{
    protected $request;
    protected $employees;

    public function __construct(Request $request,$employees)
    {
        $this->request = $request;
        $this->employees = $employees;
    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $employees = $this->employees;
        $results = [];

        $count = 1;
        foreach($employees as $employee){
            $results [] = [
                'employee_curp' => $employee->curp,
                'employee' => $employee->name,
                'date_payment' => $this->request->date_payment,
                'date_start_payment' => $this->request->date_start_payment,
                'date_end_payment' => $this->request->date_end_payment,
                'payment_days' => $this->request->payment_days,
                'amount_assimilated' => 0,
                'amount_isr' => 0,
            ];
            if($count > 100){
                break;
            }
            $count++;
        }

        return collect($results);
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            __('base/employee.entry_curp'),
            __('base/employee.entry_name'),
            __('base/payroll.entry_date_payment'),
            __('base/payroll.entry_date_start_payment'),
            __('base/payroll.entry_date_end_payment'),
            __('base/payroll.entry_payment_days'),
            __('base/payroll.text_amount_assimilated'),
            __('base/payroll.text_amount_isr'),
        ];
    }
}
