<?php

namespace App\Exports;

use App\Helpers\Helper;
use App\Models\Base\BranchOffice;
use App\Models\Catalogs\PayrollType;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Illuminate\Http\Request;
use App\Models\Catalogs\Deduction;
use App\Models\Catalogs\OtherPaymentType;
use App\Models\Catalogs\Perception;
use App\Models\Catalogs\DisabilityType;

class PayrollsTemplateImportExport implements FromCollection, WithHeadings
{
    protected $request;
    protected $employees;

    public function __construct(Request $request,$employees)
    {
        $this->request = $request;
        $this->employees = $employees;
    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $employees = $this->employees;
        $results = [];

        $count = 1;
        foreach($employees as $employee){
            $results [] = [
                'employee_curp' => $employee->curp,
                'employee' => $employee->name,
                'date_payment' => $this->request->date_payment,
                'date_start_payment' => $this->request->date_start_payment,
                'date_end_payment' => $this->request->date_end_payment,
                'payment_days' => $this->request->payment_days,
            ];
            if($count > 100){
                break;
            }
            $count++;
        }

        return collect($results);
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        $tmp = [
            __('base/employee.entry_curp'),
            __('base/employee.entry_name'),
            __('base/payroll.entry_date_payment'),
            __('base/payroll.entry_date_start_payment'),
            __('base/payroll.entry_date_end_payment'),
            __('base/payroll.entry_payment_days'),
        ];

        $perceptions = Perception::active()->whereIn('id', $this->request->perceptions)->orderBy('code')->orderBy('name')->get();
        foreach($perceptions as $perception){
            array_push($tmp, '['.$perception->code.'] ' . str_limit($perception->name,60) . ' ('.__('base/employee_payroll.column_line_amount_taxed').')' . ' (P-'.$perception->id.')');
            array_push($tmp, '['.$perception->code.'] ' . str_limit($perception->name,60) . ' ('.__('base/employee_payroll.column_line_amount_exempt').')' . ' (P-'.$perception->id.')');
            if ($perception->code == '019'){
                array_push($tmp, '['.$perception->code.'] '  .__('base/employee_payroll.column_line_hr_1_days'));
                array_push($tmp, '['.$perception->code.'] '  .__('base/employee_payroll.column_line_hr_1_hours'));
                array_push($tmp, '['.$perception->code.'] '  .__('base/employee_payroll.column_line_hr_1_amount_paid'));
                array_push($tmp, '['.$perception->code.'] '  .__('base/employee_payroll.column_line_hr_2_days'));
                array_push($tmp, '['.$perception->code.'] '  .__('base/employee_payroll.column_line_hr_2_hours'));
                array_push($tmp, '['.$perception->code.'] '  .__('base/employee_payroll.column_line_hr_2_amount_paid'));
                array_push($tmp, '['.$perception->code.'] '  .__('base/employee_payroll.column_line_hr_3_days'));
                array_push($tmp, '['.$perception->code.'] '  .__('base/employee_payroll.column_line_hr_3_hours'));
                array_push($tmp, '['.$perception->code.'] '  .__('base/employee_payroll.column_line_hr_3_amount_paid'));
            }
        }
        $deductions = Deduction::active()->whereIn('id', $this->request->deductions)->orderBy('code')->orderBy('name')->get();
        foreach($deductions as $deduction){
            array_push($tmp, '['.$deduction->code.'] ' . str_limit($deduction->name,60) . ' (D-'.$deduction->id.')');
        }
        $other_payment_types = OtherPaymentType::active()->whereIn('id', $this->request->other_payment_types)->orderBy('code')->orderBy('name')->get();
        foreach($other_payment_types as $other_payment_type){
            array_push($tmp, '['.$other_payment_type->code.'] ' . str_limit($other_payment_type->name,90) . ' (O-'.$other_payment_type->id.')');
            if ($other_payment_type->code == '002'){
                array_push($tmp, '['.$other_payment_type->code.'] '  .__('base/employee_payroll.column_line_amount_caused') . ' (O-'.$other_payment_type->id.')');
            }
        }

        if(!empty($this->request->disability_types)){
            $disability_types = DisabilityType::active()->whereIn('id', $this->request->disability_types)->orderBy('code')->orderBy('name')->get();
            foreach($disability_types as $disability_type){
                array_push($tmp, '['.$disability_type->code.'] ' . str_limit($disability_type->name,60) . ' ('.__('base/employee_payroll.column_line_disability_days').')' . ' (I-'.$disability_type->id.')');
                array_push($tmp, '['.$disability_type->code.'] ' . str_limit($disability_type->name,60) . ' ('.__('base/employee_payroll.column_line_disability_amount').')' . ' (I-'.$disability_type->id.')');
            }
        }

        return $tmp;
    }
}
