<?php

namespace App\Exports;

use App\Models\Catalogs\CfdiUse;
use App\Models\Catalogs\City;
use App\Models\Catalogs\Country;
use App\Models\Catalogs\PaymentMethod;
use App\Models\Catalogs\PaymentTerm;
use App\Models\Catalogs\PaymentWay;
use App\Models\Catalogs\SatProduct;
use App\Models\Catalogs\State;
use App\Models\Catalogs\Tax;
use App\Models\Catalogs\UnitMeasure;
use App\Models\Sales\Salesperson;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class ProductTemplateImportExport implements FromCollection, WithHeadings
{
    protected $import_results;

    public function __construct(Request $request,$import_results)
    {
        $this->request = $request;
        $this->import_results = $import_results;
    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        foreach($this->import_results as $key => $result){
            if(!empty($this->request->unit_measure_id)){
                $unit_measure = UnitMeasure::findOrFail($this->request->unit_measure_id);
                if(!empty($unit_measure)){
                    $this->import_results[$key]->unit_measure = !empty($unit_measure) ? $unit_measure->code . '-' .$unit_measure->name : '';
                }
            }
            if(!empty($this->request->sat_product_id)){
                $sat_product = SatProduct::findOrFail($this->request->sat_product_id);
                if(!empty($sat_product)){
                    $this->import_results[$key]->sat_product = $sat_product->code;
                }
            }
            $taxes = null;
            $taxes_str = '';
            if(!empty($this->request->taxes)){
                $taxes = $this->request->taxes;
                $taxes_tmp = [];
                for($i = 0; $i < count($taxes); $i++){
                    $tax = Tax::findOrFail($taxes[$i]);
                    array_push($taxes_tmp,$tax->name);
                }
                if(!empty($taxes_tmp)){
                    $this->import_results[$key]->taxes = join(', ', $taxes_tmp);
                }
            }
            if(!empty($this->request->price)){
                $this->import_results[$key]->price = $this->request->price;
            }

        }
        return collect($this->import_results);
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            __('catalogs/product.entry_code'),
            __('catalogs/product.entry_name'),
            __('catalogs/product.entry_description'),
            __('catalogs/product.entry_model'),
            __('catalogs/product.entry_manufacturer'),
            __('catalogs/product.entry_unit_measure_id'),
            __('catalogs/product.entry_sat_product_id'),
            __('catalogs/product.entry_price'),
            __('catalogs/product.entry_taxes'),
        ];
    }
}
