<?php

namespace App\Helpers;

use App\Models\Base\BranchOffice;
use App\Models\Base\Company;
use App\Models\Base\DocumentType;
use App\Models\Base\EmployeePayroll;
use App\Models\Base\Folio;
use App\Models\Base\Pac;
use App\Models\Base\Payroll;
use App\Models\Catalogs\Postcode;
use App\Models\Sales\CustomerInvoice;
use App\Models\Sales\CustomerPayment;
use Chumper\Zipper\Facades\Zipper;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Str;
use NumberToWords\NumberToWords;
use SoapClient;
use ZipArchive;
use Symfony\Component\Process\Exception\ProcessFailedException;
use Symfony\Component\Process\Process;

class BaseHelper
{

    /**
     * Estatus de factura en html
     *
     * @param $status
     * @return string
     */
    public static function statusFolioHtml($status)
    {
        $html = '';
        if ((int)$status == Folio::PER_ACTIVE) {
            $html = '<label class="label label-warning">' . __('base/folio.text_status_per_active') . '</label>';
        } elseif ((int)$status == Folio::ACTIVE) {
            $html = '<label class="label label-primary">' . __('base/folio.text_status_active') . '</label>';
        } elseif ((int)$status == Folio::FINISHED) {
            $html = '<label class="label label-success">' . __('base/folio.text_status_finished') . '</label>';
        } elseif ((int)$status == Folio::CANCELED) {
            $html = '<label class="label label-default">' . __('base/folio.text_status_canceled') . '</label>';
        } else {

        }

        return $html;
    }

    /**
     * Valida folios disponibles
     * con el RFC de la empresa default
     *
     * @return int
     */
    public static function getAvailableFolios(){
        if(empty(setting('disabled_folio_cart'))) {
            $tmp = Folio::where('status', '=', Folio::ACTIVE)
                ->where('available_folio', '>', 0)
                ->where(function($query) {
                    $query->where('expiry_date', '>=', \Date::today())
                        ->orWhereNull('expiry_date');
                })
                ->sum('available_folio');
            if(empty($tmp) && !empty(setting('folios_to_pay'))){
                $tmp = Folio::where('status', '=', Folio::PER_ACTIVE)
                ->where('available_folio', '>', 0)
                ->where(function($query) {
                    $query->where('expiry_date', '>=', \Date::today())
                        ->orWhereNull('expiry_date');
                })
                ->sum('available_folio');
            }
            $qty = !empty($tmp) ? $tmp : 0;
        }else{
            $qty = 1;
        }

        return $qty;
    }

    /**
     * Disminuye folios utilizados
     * si hay varios activos utiliza el primero encontrado
     *
     */
    public static function decrementFolios(){
        if(empty(setting('disabled_folio_cart'))) {
            $tmp = Folio::where('status', '=', Folio::ACTIVE)
                ->where('available_folio', '>', 0)
                ->where(function($query) {
                    $query->where('expiry_date', '>=', \Date::today())
                        ->orWhereNull('expiry_date');
                })
                ->orderBy('created_at')/*Utiliza el mas antiguo*/
                ->get()->first();

            if(empty($tmp) && !empty(setting('folios_to_pay'))){
                $tmp = Folio::where('status', '=', Folio::PER_ACTIVE)
                ->where('available_folio', '>', 0)
                ->where(function($query) {
                    $query->where('expiry_date', '>=', \Date::today())
                        ->orWhereNull('expiry_date');
                })
                ->orderBy('created_at')/*Utiliza el mas antiguo*/
                ->get()->first();
            }

            //Validacion en caso de estar vacio
            if (empty($tmp)) {
                throw new \Exception(__('general.error_available_folios'));
            }
            $tmp->decrement('available_folio');
        }

        return true;
    }

    /**
     * Estatus de factura en html
     *
     * @param $status
     * @return string
     */
    public static function statusEmployeePayrollHtml($status)
    {
        $html = '';
        if ((int)$status == EmployeePayroll::DRAFT) {
            $html = '<label class="label label-warning">' . __('base/employee_payroll.text_status_draft') . '</label>';
        } elseif ((int)$status == EmployeePayroll::OPEN) {
            $html = '<label class="label label-success">' . __('base/employee_payroll.text_status_open') . '</label>';
        } elseif ((int)$status == EmployeePayroll::CANCEL) {
            $html = '<label class="label label-default">' . __('base/employee_payroll.text_status_cancel') . '</label>';
        }else {

        }

        return $html;
    }

    /**
     * Estatus de factura en html
     *
     * @param $status
     * @return string
     */
    public static function statusPayrollHtml($status)
    {
        $html = '';
        if ((int)$status == Payroll::DRAFT) {
            $html = '<label class="label label-warning">' . __('base/payroll.text_status_draft') . '</label>';
        } elseif ((int)$status == Payroll::OPEN) {
            $html = '<label class="label label-success">' . __('base/payroll.text_status_open') . '</label>';
        } elseif ((int)$status == Payroll::CANCEL) {
            $html = '<label class="label label-default">' . __('base/payroll.text_status_cancel') . '</label>';
        }else {

        }

        return $html;
    }

    /**
     * Obtiene fecha de acuerdo a zona horaria de codigo postal de la matriz
     *
     * @param $id
     * @return mixed
     */
    public static function getDateTimeBranchOffice($id){
        $branch_office = BranchOffice::findOrFail($id);
        $postcode = Postcode::where('name','=',$branch_office->postcode)->first();
        $hours = 0;
        if(!empty($postcode)){
            $hours = 6 - abs($postcode->diff2);
        }
        $cfdi_date = \Date::now();
        if($hours > 0){
            $cfdi_date->addHours($hours);
        }elseif($hours < 0){
            $cfdi_date->subHours(abs($hours));
        }

        return $cfdi_date;
    }

}
