<?php
/**
 * Librería para descarga masiva de CFDI emitidos y recibidos
 * del servidor del SAT.
 *
 * @author  Noel Miranda <noelmrnd@gmail.com>
 * @version 5.0.0
 */
namespace App\Helpers;

class BusquedaEmitidosHelper extends BusquedaHelper {
    public $rfc_receptor  = '';
    public $fecha_inicial;
    public $fecha_final;
    public $hfInicial;
    public $hfFinal;



    public function __construct() {
        $this->hfInicial = date('Y');
        $this->hfFinal = date('n');
    }

    /**
     * Permite indicar la fecha inicial de búsqueda
     * @param int $anio año a 4 dígitos
     * @param int $mes mes del 1 a 12
     * @param int $dia día del 1 al 31
     */
    public function establecerFechaInicial($anio, $mes, $dia, $hora_inicial = null,$minuto_inicial = null){
        $this->hfInicial = (string)$anio;
        $this->fecha_inicial =
            str_pad($dia, 2, '0', STR_PAD_LEFT) . '/' .
            str_pad($mes, 2, '0', STR_PAD_LEFT) . '/' .
            (string)$anio;
        if(!empty($hora_inicial)){
            $this->hora_inicial = $hora_inicial;
        }
        if(!empty($minuto_inicial)){
            $this->minuto_inicial = $minuto_inicial;
        }
        $this->setTipoBusqueda('fecha');
    }

    /**
     * Permite indicar la fecha final de búsqueda
     * @param int $anio año a 4 dígitos
     * @param int $mes mes del 1 a 12
     * @param int $dia día del 1 al 31
     */
    public function establecerFechaFinal($anio, $mes, $dia, $hora_final = null,$minuto_final = null){
        $this->hfFinal = (string)$anio;
        $this->fecha_final =
            str_pad($dia, 2, '0', STR_PAD_LEFT) . '/' .
            str_pad($mes, 2, '0', STR_PAD_LEFT) . '/' .
            (string)$anio;
        if(!empty($hora_final)){
            $this->hora_final = $hora_final;
        }
        if(!empty($minuto_final)){
            $this->minuto_final = $minuto_final;
        }
        $this->setTipoBusqueda('fecha');
    }

    /**
     * Permite establecer el RFC del receptor
     * @param string $rfc RFC del emisor
     */
    public function establecerRfcReceptor($rfc){
        $this->rfc_receptor = $rfc;
        $this->setTipoBusqueda('fecha');
    }

    public function obtenerFormulario(){
        $estadoStr = '1';
        $vigenteStr = '0';
        $canceladoStr = '0';
        switch ($this->estado) {
            case self::ESTADO_VIGENTE:
                break;
            case self::ESTADO_VIGENTE_EP:
                $vigenteStr = '1';
                break;
            case self::ESTADO_VIGENTE_R:
                $vigenteStr = '4';
                break;
            case self::ESTADO_VIGENTE_SP:
                $vigenteStr = '-1';
                break;
            case self::ESTADO_VIGENTE_V:
                $vigenteStr = '5';
                break;
            case self::ESTADO_CANCELADO:
                $estadoStr = '0';
                break;
            case self::ESTADO_CANCELADO_SA:
                $estadoStr = '0';
                $canceladoStr = '3';
                break;
            case self::ESTADO_CANCELADO_CA:
                $estadoStr = '0';
                $canceladoStr = '2';
                break;
            case self::ESTADO_CANCELADO_PV:
                $estadoStr = '0';
                $canceladoStr = '5';
                break;
            case self::ESTADO_TODOS:
            default:
                $estadoStr = '-1';
                break;
        }

        return array(
            '__ASYNCPOST' =>'true',
            // '__EVENTARGUMENT' => '',
            // '__EVENTTARGET' => '',
            // '__LASTFOCUS' => '',
            'ctl00$MainContent$BtnBusqueda' => 'Buscar CFDI',
            'ctl00$MainContent$hfInicial' => $this->hfInicial,
            'ctl00$MainContent$hfInicialBool' => 'false',
            'ctl00$MainContent$CldFechaInicial2$Calendario_text' => $this->fecha_inicial,
            'ctl00$MainContent$CldFechaInicial2$DdlHora' => $this->hora_inicial,
            'ctl00$MainContent$CldFechaInicial2$DdlMinuto' => $this->minuto_inicial,
            'ctl00$MainContent$CldFechaInicial2$DdlSegundo' => $this->segundo_inicial,
            'ctl00$MainContent$hfFinal' => $this->hfFinal,
            'ctl00$MainContent$hfFinalBool' => 'false',
            'ctl00$MainContent$CldFechaFinal2$Calendario_text' => $this->fecha_final,
            'ctl00$MainContent$CldFechaFinal2$DdlHora' => $this->hora_final,
            'ctl00$MainContent$CldFechaFinal2$DdlMinuto' => $this->minuto_final,
            'ctl00$MainContent$CldFechaFinal2$DdlSegundo' => $this->segundo_final,
            'ctl00$MainContent$DdlEstadoComprobante' => $estadoStr,
            'ctl00$MainContent$ddlVigente' => $vigenteStr,
            'ctl00$MainContent$ddlCancelado' => $canceladoStr,
            'ctl00$MainContent$TxtRfcReceptor' => $this->rfc_receptor,
            'ctl00$MainContent$TxtUUID' => $this->folio_fiscal,
            'ctl00$MainContent$ddlComplementos' => $this->tipoComplemento,
            'ctl00$MainContent$FiltroCentral' =>
                ($this->tipoBusqueda == 'fecha') ? 'RdoFechas' : 'RdoFolioFiscal'
        );
    }

    public function obtenerFormularioAjax($post, $fuente){
        $valores = explode('|', $fuente);
        $validos = array(
            'EVENTTARGET',
            '__EVENTARGUMENT',
            '__LASTFOCUS',
            '__VIEWSTATE',
            '__CSRFTOKEN', // ?
            'ctl00$ScriptManager1', // ?
        );
        $valCount = count($valores);
        $items = array();
        for ($i=0; $i < $valCount; $i++) {
            $item = $valores[$i];
            if(in_array($item, $validos)){
                $items[$item] = $valores[$i+1];
            }
        }

        return array_merge(
            array_merge(
                $post,
                $this->obtenerFormulario()
            ),
            $items
        );
    }
}
