<?php
/**
 * Librería para descarga masiva de CFDI emitidos y recibidos
 * del servidor del SAT.
 *
 * @author  Noel Miranda <noelmrnd@gmail.com>
 * @version 5.0.0
 */
namespace App\Helpers;

class BusquedaHelper {
    const ESTADO_TODOS          = 1;  // Todos
    const ESTADO_VIGENTE        = 2;  // Todos los vigentes
    const ESTADO_CANCELADO      = 6;  // Todos los cancelados
    const ESTADO_VIGENTE_EP     = 7;  // Vigentes (en proceso)
    const ESTADO_VIGENTE_R      = 8;  // Vigentes (rechazados)
    const ESTADO_VIGENTE_V      = 9;  // Vigentes (vencidos)
    const ESTADO_VIGENTE_SP     = 10; // Vigentes (sin proceso)
    const ESTADO_CANCELADO_CA   = 3;  // Cancelado (con aceptación)
    const ESTADO_CANCELADO_SA   = 4;  // Cancelado (sin aceptación)
    const ESTADO_CANCELADO_PV   = 5;  // Cancelado (plazo vencido)

    const COMPLEMENTO_NINGUNO = '-1'; // (Mostrar todos los CFDI)
    const COMPLEMENTO_ESTANDAR = '8'; // Estándar (sin complemento)
    const COMPLEMENTO_ACRED_IEPS = '4294967296'; // Acreditamiento de IEPS
    const COMPLEMENTO_AEROLINEAS = '8388608'; // Aerolíneas
    const COMPLEMENTO_CERT_DEST = '1073741824'; // Certificado de Destrucción
    const COMPLEMENTO_CE = '17179869184'; // Comercio Exterior
    const COMPLEMENTO_CE11 = '274877906944'; // Comercio Exterior 1.1
    const COMPLEMENTO_CV_DIVISAS = '4'; // Compra Venta de Divisas
    const COMPLEMENTO_CONSUMO_COMB = '16777216'; // Consumo de Combustibles
    const COMPLEMENTO_CONSUMO_COMB11 = '8796093022208'; // Consumo De Combustibles 1.1
    const COMPLEMENTO_DONATARIAS = '64'; // Donatarias
    const COMPLEMENTO_EC_BANCARIO = '256'; // Estado De Cuenta Bancario
    const COMPLEMENTO_EC_COMB12 = '4398046511104'; // Estado de Cuenta Combustibles 1.2
    const COMPLEMENTO_EC_COMB_ME = '8589934592'; // Estado de cuenta de combustibles de monederos electrónicos.
    const COMPLEMENTO_GASTOS_HID = '17592186044416'; // Gastos de Hidrocarburos
    const COMPLEMENTO_INE11 = '68719476736'; // INE 1.1
    const COMPLEMENTO_INGRESOS_HID = '35184372088832'; // Ingresos de Hidrocarburos
    const COMPLEMENTO_INST_EDUCATIVAS = '1024'; // Instituciones Educativas Privadas (Pago de colegiatura)
    const COMPLEMENTO_LEYENDAS_FISCALES = '4096'; // Leyendas Fiscales
    const COMPLEMENTO_MIS_CUENTAS = '524288'; // Mis Cuentas
    const COMPLEMENTO_NOTARIOS = '67108864'; // Notarios Públicos
    const COMPLEMENTO_OBRAS = '536870912'; // Obras de artes y antigüedades
    const COMPLEMENTO_OTROS_DI = '2048'; // Otros Derechos e Impuestos
    const COMPLEMENTO_PAGO_ESPECIE = '4194304'; // Pago en Especie
    const COMPLEMENTO_PFI_COORDINADO = '8192'; // Persona Física Integrante de Coordinado
    const COMPLEMENTO_RECEPCION_PAGOS = '549755813888'; // Recepción de Pagos
    const COMPLEMENTO_RECIBO_DONATIVO = '128'; // Recibo de donativo
    const COMPLEMENTO_RECIBO_SALARIOS = '1048576'; // Recibo de Pago de Salarios
    const COMPLEMENTO_RECIBO_SALARIOS12 = '137438953472'; // Recibo de Pago de Salarios 1.2
    const COMPLEMENTO_DETALLISTA = '32'; // Sector de Ventas al Detalle (Detallista)
    const COMPLEMENTO_CONSTRUCCION = '268435456'; // Servicios de construcción
    const COMPLEMENTO_SPEI = '16384'; // SPEI de Tercero a Tercero
    const COMPLEMENTO_VEHICULAR = '2147483648'; // Sustitución y renovación vehicular
    const COMPLEMENTO_TERCEROS1 = '32768'; // Terceros
    const COMPLEMENTO_TERCEROS2 = '65536'; // Terceros
    const COMPLEMENTO_TIMBRE_FD = '2199023255552'; // Timbre Fiscal Digital
    const COMPLEMENTO_EXTRANJERO = '16'; // Turista o Pasajero Extranjero
    const COMPLEMENTO_VALES = '33554432'; // Vales de Despensa
    const COMPLEMENTO_VEHICULO_USADO = '134217728'; // Vehículo Usado
    const COMPLEMENTO_VENTA_VEHICULOS = '2097152'; // Venta de Vehiculos

    public $hora_inicial    =  '0';
    public $minuto_inicial  =  '0';
    public $segundo_inicial =  '0';
    public $hora_final      = '23';
    public $minuto_final    = '59';
    public $segundo_final   = '59';
    public $folio_fiscal    = '';
    public $estado          = self::ESTADO_TODOS;
    public $tipoComplemento = self::COMPLEMENTO_NINGUNO;
    public $tipoBusqueda    = 'fecha';

    /**
     * Permite indicar el estado de los CFDI a buscar
     * @param string $estado
     */
    public function establecerEstado($estado){
        $this->estado = (int)$estado;
        $this->setTipoBusqueda('fecha');
    }

    /**
     * Permite indicar la hora inicial de búsqueda
     * @param int $hora hora en formato de 24 horas (0-23)
     * @param int $minuto minuto del 0 al 59
     * @param int $segundo segundo del 0 al 59
     */
    public function establecerHoraInicial($hora='0', $minuto='0', $segundo='0'){
        $this->hora_inicial = (string)$hora;
        $this->minuto_inicial = (string)$minuto;
        $this->segundo_inicial = (string)$segundo;
        $this->setTipoBusqueda('fecha');
    }

    /**
     * Permite indicar la hora final de búsqueda
     * @param int $hora hora en formato de 24 horas (0-23)
     * @param int $minuto minuto del 0 al 59
     * @param int $segundo segundo del 0 al 59
     */
    public function establecerHoraFinal($hora='23', $minuto='59', $segundo='59'){
        $this->hora_final = (string)$hora;
        $this->minuto_final = (string)$minuto;
        $this->segundo_final = (string)$segundo;
        $this->setTipoBusqueda('fecha');
    }

    /**
     * Permite establecer el UUID
     * @param string $uuid el UUID
     */
    public function establecerFolioFiscal($uuid){
        $this->folio_fiscal = $uuid;
        $this->setTipoBusqueda('folio');
    }

    /**
     * Permite establecer el tipo de búsqueda
     * @param string $tipo "fecha" o "folio"
     */
    public function setTipoBusqueda($tipo){
        $this->tipoBusqueda = $tipo;
        if($tipo == 'fecha'){
            $this->folio_fiscal = '';
        }
    }

    /**
     * Permite establecer el tipo de comprobante a buscar
     * @param string $tipo código del tipo de comprobante.
     * Para buscar todos, no especificar ningún valor.
     */
    public function establecerTipoComplemento($tipo=self::COMPLEMENTO_NINGUNO){
        $this->tipoComplemento = $tipo;
    }

    public static function listadoComplementos() {
        return array(
            self::COMPLEMENTO_NINGUNO => 'Ninguno (todos los CFDI)',
            self::COMPLEMENTO_ESTANDAR => 'Estándar (sin complemento)',
            self::COMPLEMENTO_ACRED_IEPS => 'Acreditamiento de IEPS',
            self::COMPLEMENTO_AEROLINEAS => 'Aerolíneas',
            self::COMPLEMENTO_CERT_DEST => 'Certificado de Destrucción',
            self::COMPLEMENTO_CE => 'Comercio Exterior',
            self::COMPLEMENTO_CE11 => 'Comercio Exterior 1.1',
            self::COMPLEMENTO_CV_DIVISAS => 'Compra Venta de Divisas',
            self::COMPLEMENTO_CONSUMO_COMB => 'Consumo de Combustibles',
            self::COMPLEMENTO_CONSUMO_COMB11 => 'Consumo De Combustibles 1.1',
            self::COMPLEMENTO_DONATARIAS => 'Donatarias',
            self::COMPLEMENTO_EC_BANCARIO => 'Estado De Cuenta Bancario',
            self::COMPLEMENTO_EC_COMB12 => 'Estado de Cuenta Combustibles 1.2',
            self::COMPLEMENTO_EC_COMB_ME => 'Estado de cuenta de combustibles de monederos electrónicos.',
            self::COMPLEMENTO_GASTOS_HID => 'Gastos de Hidrocarburos',
            self::COMPLEMENTO_INE11 => 'INE 1.1',
            self::COMPLEMENTO_INGRESOS_HID => 'Ingresos de Hidrocarburos',
            self::COMPLEMENTO_INST_EDUCATIVAS => 'Instituciones Educativas Privadas (Pago de colegiatura)',
            self::COMPLEMENTO_LEYENDAS_FISCALES => 'Leyendas Fiscales',
            self::COMPLEMENTO_MIS_CUENTAS => 'Mis Cuentas',
            self::COMPLEMENTO_NOTARIOS => 'Notarios Públicos',
            self::COMPLEMENTO_OBRAS => 'Obras de artes y antigüedades',
            self::COMPLEMENTO_OTROS_DI => 'Otros Derechos e Impuestos',
            self::COMPLEMENTO_PAGO_ESPECIE => 'Pago en Especie',
            self::COMPLEMENTO_PFI_COORDINADO => 'Persona Física Integrante de Coordinado',
            self::COMPLEMENTO_RECEPCION_PAGOS => 'Recepción de Pagos',
            self::COMPLEMENTO_RECIBO_DONATIVO => 'Recibo de donativo',
            self::COMPLEMENTO_RECIBO_SALARIOS => 'Recibo de Pago de Salarios',
            self::COMPLEMENTO_RECIBO_SALARIOS12 => 'Recibo de Pago de Salarios 1.2',
            self::COMPLEMENTO_DETALLISTA => 'Sector de Ventas al Detalle (Detallista)',
            self::COMPLEMENTO_CONSTRUCCION => 'Servicios de construcción',
            self::COMPLEMENTO_SPEI => 'SPEI de Tercero a Tercero',
            self::COMPLEMENTO_VEHICULAR => 'Sustitución y renovación vehicular',
            self::COMPLEMENTO_TERCEROS1 => 'Terceros',
            self::COMPLEMENTO_TERCEROS2 => 'Terceros',
            self::COMPLEMENTO_TIMBRE_FD => 'Timbre Fiscal Digital',
            self::COMPLEMENTO_EXTRANJERO => 'Turista o Pasajero Extranjero',
            self::COMPLEMENTO_VALES => 'Vales de Despensa',
            self::COMPLEMENTO_VEHICULO_USADO => 'Vehículo Usado',
            self::COMPLEMENTO_VENTA_VEHICULOS => 'Venta de Vehiculos',
        );
    }
}
