<?php

namespace App\Helpers;

use App\Models\Base\Company;
use App\Models\Base\DocumentType;
use App\Models\Base\Pac;
use App\Models\Sales\CustomerInvoice;
use App\Models\Sales\CustomerInvoice as CustomerCreditNote;
use App\Models\Sales\CustomerInvoice as CustomerTransfer;
use App\Models\Sales\CustomerInvoice as CustomerLease;
use App\Models\Sales\CustomerInvoice as CustomerFee;
use App\Models\Sales\CustomerPayment;
use App\Models\Sales\CustomerQuotation;
use App\Models\Sales\CustomerRemission;
use Chumper\Zipper\Facades\Zipper;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Str;
use NumberToWords\NumberToWords;
use SoapClient;
use ZipArchive;
use Symfony\Component\Process\Exception\ProcessFailedException;
use Symfony\Component\Process\Process;

class SalesHelper
{
    /**
     * Estatus de factura en html
     *
     * @param $status
     * @return string
     */
    public static function statusCustomerQuotationHtml($status)
    {
        $html = '';
        if ((int)$status == CustomerQuotation::OPEN) {
            $html = '<label class="label label-success">' . __('sales/customer_quotation.text_status_open') . '</label>';
        } elseif ((int)$status == CustomerQuotation::BILLED) {
            $html = '<label class="label label-primary">' . __('sales/customer_quotation.text_status_billed') . '</label>';
        } elseif ((int)$status == CustomerQuotation::CANCEL) {
            $html = '<label class="label label-default">' . __('sales/customer_quotation.text_status_cancel') . '</label>';
        } else {

        }

        return $html;
    }

    /**
     * Estatus de factura en html
     *
     * @param $status
     * @return string
     */
    public static function statusCustomerRemissionHtml($status)
    {
        $html = '';
        if ((int)$status == CustomerRemission::OPEN) {
            $html = '<label class="label label-success">' . __('sales/customer_remission.text_status_open') . '</label>';
        } elseif ((int)$status == CustomerRemission::BILLED) {
            $html = '<label class="label label-primary">' . __('sales/customer_remission.text_status_billed') . '</label>';
        } elseif ((int)$status == CustomerRemission::CANCEL) {
            $html = '<label class="label label-default">' . __('sales/customer_remission.text_status_cancel') . '</label>';
        } else {

        }

        return $html;
    }

    /**
     * Estatus de factura en html
     *
     * @param $status
     * @return string
     */
    public static function statusCustomerInvoiceHtml($status)
    {
        $html = '';
        if ((int)$status == CustomerInvoice::DRAFT) {
            $html = '<label class="label label-warning">' . __('sales/customer_invoice.text_status_draft') . '</label>';
        } elseif ((int)$status == CustomerInvoice::OPEN) {
            $html = '<label class="label label-success">' . __('sales/customer_invoice.text_status_open') . '</label>';
        } elseif ((int)$status == CustomerInvoice::TO_PAY) {
            $html = '<label class="label label-info">' . __('sales/customer_invoice.text_status_to_pay') . '</label>';
        } elseif ((int)$status == CustomerInvoice::PAID) {
            $html = '<label class="label label-primary">' . __('sales/customer_invoice.text_status_paid') . '</label>';
        } elseif ((int)$status == CustomerInvoice::CANCEL) {
            $html = '<label class="label label-default">' . __('sales/customer_invoice.text_status_cancel') . '</label>';
        } elseif ((int)$status == CustomerInvoice::CANCEL_PER_AUTHORIZED) {
            $html = '<label class="label label-dark">' . __('sales/customer_invoice.text_status_cancel_per_authorized') . '</label>';
        } else {

        }

        return $html;
    }

    /**
     * Estatus de factura en html
     *
     * @param $status
     * @return string
     */
    public static function statusCustomerCreditNoteHtml($status)
    {
        $html = '';
        if ((int)$status == CustomerCreditNote::DRAFT) {
            $html = '<label class="label label-warning">' . __('sales/customer_credit_note.text_status_draft') . '</label>';
        } elseif ((int)$status == CustomerCreditNote::OPEN) {
            $html = '<label class="label label-success">' . __('sales/customer_credit_note.text_status_open') . '</label>';
        } elseif ((int)$status == CustomerCreditNote::PER_RECONCILED) {
            $html = '<label class="label label-info">' . __('sales/customer_credit_note.text_status_per_reconciled') . '</label>';
        } elseif ((int)$status == CustomerCreditNote::RECONCILED) {
            $html = '<label class="label label-primary">' . __('sales/customer_credit_note.text_status_reconciled') . '</label>';
        } elseif ((int)$status == CustomerCreditNote::CANCEL) {
            $html = '<label class="label label-default">' . __('sales/customer_credit_note.text_status_cancel') . '</label>';
        } else {

        }

        return $html;
    }

    /**
     * Estatus de pagos en html
     *
     * @param $status
     * @return string
     */
    public static function statusCustomerPaymentHtml($status)
    {
        $html = '';
        if ((int)$status == CustomerPayment::DRAFT) {
            $html = '<label class="label label-warning">' . __('sales/customer_payment.text_status_draft') . '</label>';
        } elseif ((int)$status == CustomerPayment::OPEN) {
            $html = '<label class="label label-success">' . __('sales/customer_payment.text_status_open') . '</label>';
        } elseif ((int)$status == CustomerPayment::PER_RECONCILED) {
            $html = '<label class="label label-info">' . __('sales/customer_payment.text_status_per_reconciled') . '</label>';
        } elseif ((int)$status == CustomerPayment::RECONCILED) {
            $html = '<label class="label label-primary">' . __('sales/customer_payment.text_status_reconciled') . '</label>';
        } elseif ((int)$status == CustomerPayment::CANCEL) {
            $html = '<label class="label label-default">' . __('sales/customer_payment.text_status_cancel') . '</label>';
        } else {

        }

        return $html;
    }

    /**
     * Estatus de pagos en html
     *
     * @param $status
     * @return string
     */
    public static function statusCustomerTransferHtml($status)
    {
        $html = '';
        if ((int)$status == CustomerTransfer::DRAFT) {
            $html = '<label class="label label-warning">' . __('sales/customer_transfer.text_status_draft') . '</label>';
        } elseif ((int)$status == CustomerTransfer::OPEN) {
            $html = '<label class="label label-success">' . __('sales/customer_transfer.text_status_open') . '</label>';
        } elseif ((int)$status == CustomerTransfer::CANCEL) {
            $html = '<label class="label label-default">' . __('sales/customer_transfer.text_status_cancel') . '</label>';
        } else {

        }

        return $html;
    }

    /**
     * Estatus de recibos de arrendamiento en html
     *
     * @param $status
     * @return string
     */
    public static function statusCustomerLeaseHtml($status)
    {
        $html = '';
        if ((int)$status == CustomerLease::DRAFT) {
            $html = '<label class="label label-warning">' . __('sales/customer_lease.text_status_draft') . '</label>';
        } elseif ((int)$status == CustomerLease::OPEN) {
            $html = '<label class="label label-success">' . __('sales/customer_lease.text_status_open') . '</label>';
        } elseif ((int)$status == CustomerLease::TO_PAY) {
            $html = '<label class="label label-info">' . __('sales/customer_lease.text_status_to_pay') . '</label>';
        } elseif ((int)$status == CustomerLease::PAID) {
            $html = '<label class="label label-primary">' . __('sales/customer_lease.text_status_paid') . '</label>';
        } elseif ((int)$status == CustomerLease::CANCEL) {
            $html = '<label class="label label-default">' . __('sales/customer_lease.text_status_cancel') . '</label>';
        } elseif ((int)$status == CustomerLease::CANCEL_PER_AUTHORIZED) {
            $html = '<label class="label label-dark">' . __('sales/customer_lease.text_status_cancel_per_authorized') . '</label>';
        } else {

        }

        return $html;
    }

    /**
     * Estatus de recibos de honorarios en html
     *
     * @param $status
     * @return string
     */
    public static function statusCustomerFeeHtml($status)
    {
        $html = '';
        if ((int)$status == CustomerFee::DRAFT) {
            $html = '<label class="label label-warning">' . __('sales/customer_fee.text_status_draft') . '</label>';
        } elseif ((int)$status == CustomerFee::OPEN) {
            $html = '<label class="label label-success">' . __('sales/customer_fee.text_status_open') . '</label>';
        } elseif ((int)$status == CustomerFee::TO_PAY) {
            $html = '<label class="label label-info">' . __('sales/customer_fee.text_status_to_pay') . '</label>';
        } elseif ((int)$status == CustomerFee::PAID) {
            $html = '<label class="label label-primary">' . __('sales/customer_fee.text_status_paid') . '</label>';
        } elseif ((int)$status == CustomerFee::CANCEL) {
            $html = '<label class="label label-default">' . __('sales/customer_fee.text_status_cancel') . '</label>';
        } elseif ((int)$status == CustomerFee::CANCEL_PER_AUTHORIZED) {
            $html = '<label class="label label-dark">' . __('sales/customer_fee.text_status_cancel_per_authorized') . '</label>';
        } else {

        }

        return $html;
    }

}
