<?php

namespace App\Helpers;

use App\Models\Base\Company;
use App\Models\Base\DocumentType;
use App\Models\Base\Folio;
use App\Models\Base\Pac;
use App\Models\Sales\CustomerInvoice;
use App\Models\Sales\CustomerPayment;
use App\Models\System\SysSalesOrder;
use Chumper\Zipper\Facades\Zipper;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Str;
use NumberToWords\NumberToWords;
use SoapClient;
use ZipArchive;
use Symfony\Component\Process\Exception\ProcessFailedException;
use Symfony\Component\Process\Process;

class SystemHelper
{

    /**
     * Estatus de factura en html
     *
     * @param $status
     * @return string
     */
    public static function statusSalesOrderHtml($status)
    {
        $html = '';
        if ((int)$status == SysSalesOrder::PER_ACTIVE) {
            $html = '<label class="label label-warning">' . __('system/sys_sales_order.text_status_per_active') . '</label>';
        } elseif ((int)$status == SysSalesOrder::ACTIVE) {
            $html = '<label class="label label-primary">' . __('system/sys_sales_order.text_status_active') . '</label>';
        } elseif ((int)$status == SysSalesOrder::CANCELED) {
            $html = '<label class="label label-default">' . __('system/sys_sales_order.text_status_canceled') . '</label>';
        } else {

        }

        return $html;
    }

}