<?php
/**
 * Librería para descarga masiva de CFDI emitidos y recibidos
 * del servidor del SAT.
 *
 * @author  Noel Miranda <noelmrnd@gmail.com>
 * @version 5.0.0
 */
namespace App\Helpers;

class XmlInfoHelper {
    public $urlDescargaXml;
    public $urlDescargaAcuse;
    public $urlDescargaRI;
    public $folioFiscal;
    public $emisorRfc;
    public $emisorNombre;
    public $receptorRfc;
    public $receptorNombre;
    public $fechaEmision;
    public $fechaCertificacion;
    public $pacCertifico;
    public $total;
    public $efecto;
    public $estado;
    public $estadoCancelacion;
    public $estadoProcesoCancelacion;
    public $fechaCancelacion;

    /**
     * @deprecated 3.0.0 Utilice la variable $urlDescargaAcuse
     */
    public $urlAcuseXml;


    public function esVigente(){
        return $this->estado === 'Vigente';
    }
    public function esCancelado(){
        return $this->estado === 'Cancelado';
    }

    public static function fromHtmlElement($xpath, $trElement, $modulo){
        if($trElement && $trElement->childNodes->length == 0) {
            return null;
        }

        $xml = new self;

        $index = 0;
        foreach ($trElement->childNodes as $node) {
            if($node->nodeName != 'td') {
                continue;
            }
            if($index == 0) {
                if($nodeSpan = $xpath->query('*//span[@id="BtnDescarga"]', $node)->item(0)) {
                    $xml->urlDescargaXml = DescargaMasivaCfdiHelper::URL_PORTAL_CFDI . str_replace(
                        array('return AccionCfdi(\'','\',\'Recuperacion\');'),
                        '',
                        $nodeSpan->getAttribute('onclick')
                    );
                }
                if($nodeSpan = $xpath->query('*//span[@id="BtnRecuperaAcuseFinal"]', $node)->item(0)) {
                    $xml->urlDescargaAcuse = DescargaMasivaCfdiHelper::URL_PORTAL_CFDI . str_replace(
                        array('javascript:window.location.href=\'','\';'),
                        '',
                        $nodeSpan->getAttribute('onclick')
                    );
                }
                if($nodeSpan = $xpath->query('*//span[@id="BtnRI"]', $node)->item(0)) {
                    $xml->urlDescargaRI = DescargaMasivaCfdiHelper::URL_PORTAL_CFDI
                        . 'RepresentacionImpresa.aspx?Datos=' . str_replace(
                        array('recuperaRepresentacionImpresa(\'','\');'),
                        '',
                        $nodeSpan->getAttribute('onclick')
                    );
                }
            }else{
                $value = $node->nodeValue;
                $value = html_entity_decode($value);
                $value = utf8_decode($value);
                $value = str_replace(chr(160), chr(32), $value);
                $value = trim($value);
                switch ($index) {
                    case  1: $xml->folioFiscal = strtoupper($value); break;
                    case  2: $xml->emisorRfc = $value; break;
                    case  3: $xml->emisorNombre = $value; break;
                    case  4: $xml->receptorRfc = $value; break;
                    case  5: $xml->receptorNombre = $value; break;
                    case  6: $xml->fechaEmision = $value; break;
                    case  7: $xml->fechaCertificacion = $value; break;
                    case  8: $xml->pacCertifico = $value; break;
                    case  9: $xml->total = $value; break;
                    case 10: $xml->efecto = $value; break;
                    case 11: $xml->estadoCancelacion = $value; break;
                    case 12: $xml->estado = $value; break;
                    case 13: $xml->estadoProcesoCancelacion = $value; break;
                    case 14: $xml->fechaCancelacion = $value; break;
                }
            }
            $index++;
        }

        return $xml;
    }
}
