<?php

namespace App\Http\Controllers\Base;

use App\Models\Base\BlackListSat;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class BlackListSatController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //Variables
        $limit = ($request->has('limit') ? $request->get('limit') : 100);

        //Consulta
        $results = BlackListSat::filter($request->all())->sortable('name')->paginate($limit);

        //Vista
        return view('base.black_list_sats.index', compact('results'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //Redireccion
        return redirect('/base/black-list-sats');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //Redireccion
        return redirect('/base/black-list-sats');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Base\BlackListSat  $blackListSat
     * @return \Illuminate\Http\Response
     */
    public function show(BlackListSat $blackListSat)
    {
        //Redireccion
        return redirect('/base/black-list-sats');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Base\BlackListSat  $blackListSat
     * @return \Illuminate\Http\Response
     */
    public function edit(BlackListSat $blackListSat)
    {
        //Redireccion
        return redirect('/base/black-list-sats');
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Base\BlackListSat  $blackListSat
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, BlackListSat $blackListSat)
    {
        //Redireccion
        return redirect('/base/black-list-sats');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Base\BlackListSat  $blackListSat
     * @return \Illuminate\Http\Response
     */
    public function destroy(BlackListSat $blackListSat)
    {
        //Redireccion
        return redirect('/base/black-list-sats');
    }
}
