<?php

namespace App\Http\Controllers\Base;

use App\Helpers\Helper;
use App\Models\Base\Diot;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\Base\DiotLine;
use App\Models\Base\CfdiDownload;
use App\Models\Catalogs\CfdiType;
use App\Http\Controllers\Controller;

class DiotController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //Variables
        $limit = ($request->has('limit') ? $request->get('limit') : 100);
        $months = __('general.text_months');
        if (empty($request->filter_date_from)) {
            $request->request->add([
                'filter_date_from' => Helper::date(\Date::parse('first day of this month')->subMonth())
            ]);
        }
        if (empty($request->filter_date_to)) {
            $request->request->add([
                'filter_date_to' => Helper::date(\Date::parse('last day of this month'))
            ]);
        }

        //Consulta
        $results = Diot::filter($request->all())
            ->sortable(['date' => 'desc'])->paginate($limit);


        //Vista
        return view('base.diots.index', compact('results','months'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //Variables
        $year_1 = \Date::now()->subYears(6)->format('Y');
        $year_2 = \Date::now()->format('Y');
        for($i=$year_1;$i <= $year_2;$i++){
            $years[$i] = $i;
        }
        $months = array_merge(['' => __('general.text_select')],__('general.text_months'));
        $diot_countries = array_merge(['' => __('general.text_select')],__('general.text_diot_countries'));
        $diot_customer_types = array_merge(['' => __('general.text_select')],__('general.text_diot_customer_types'));
        $diot_operation_types = array_merge(['' => __('general.text_select')],__('general.text_diot_operation_types'));

        return view('base.diots.create',compact('years','months','diot_countries','diot_customer_types','diot_operation_types'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //Validacion

        \DB::connection('tenant')->beginTransaction();
        try {
            //
            $company = Helper::defaultCompany(); //Empresa

            //
            $diot = Diot::create([
                'created_uid' => \Auth::user()->id,
                'updated_uid' => \Auth::user()->id,
                'name' => $request->name,
                'date' => \Date::now(),
                'month' => $request->month,
                'year' => $request->year,
                'file' => null,
                'company_id'=> $company->id,
                'status' => 1,
            ]);

            //
            if (!empty($request->item)) {
                foreach ($request->item as $key => $item) {
                    $item = (object)$item;
                    $diot_line = DiotLine::create([
                        'created_uid' => \Auth::user()->id,
                        'updated_uid' => \Auth::user()->id,
                        'diot_id' => $diot->id,
                        'cfdi_download_id' => $item->cfdi_download_id,
                        'customer_type' => $item->customer_type,
                        'operation_type' => $item->operation_type,
                        'taxid' => $item->taxid,
                        'numid' => $item->numid,
                        'name' => $item->name,
                        'foreign_country_code' => $item->foreign_country_code,
                        'foreign_nationality' => $item->foreign_nationality,
                        'iva_15_16' => (double)$item->iva_15_16,
                        'iva_15' => (double)$item->iva_15,
                        'iva_15_16_not' => (double)$item->iva_15_16_not,
                        'iva_10_11' => (double)$item->iva_10_11,
                        'iva_10' => (double)$item->iva_10,
                        'border_stimulation' => (double)$item->border_stimulation,
                        'iva_10_11_not' => (double)$item->iva_10_11_not,
                        'border_stimulation_not' => (double)$item->border_stimulation_not,
                        'foreign_iva_15_16' => $item->customer_type=='05' ? (double)$item->iva_15_16 : 0,
                        'foreign_iva_15_16_not' => $item->customer_type=='05' ? (double)$item->iva_15_16_not : 0,
                        'foreign_iva_10_11' => $item->customer_type=='05' ? (double)$item->iva_10_11 : 0,
                        'foreign_iva_10_11_not' => $item->customer_type=='05' ? (double)$item->iva_10_11_not : 0,
                        'foreign_exempt' => $item->customer_type=='05' ? (double)$item->exempt : 0,
                        'iva_0' => (double)$item->iva_0,
                        'exempt' => (double)$item->exempt,
                        'iva_detained' => (double)$item->iva_detained,
                        'iva_dev_dis_bon' => (double)$item->iva_dev_dis_bon,
                        'sort_order' => $key,
                        'status' => 1,
                    ]);
                }
            }
            $diot_line_grouped = $diot->diotLines->groupBy('taxid');
            $txt = '';
            foreach($diot_line_grouped as $result){
                if($result->first()->taxid == 'XEXX010101000'){
                    $diot_line_grouped_2 = $result->groupBy('name');
                    foreach($diot_line_grouped_2 as $result){
                        $customer_type = $result->first()->customer_type;
                        $operation_type = $result->first()->operation_type;
                        $taxid = ($result->first()->customer_type=='04' ? $result->first()->taxid : '');
                        $numid = ($result->first()->customer_type=='05' ? $result->first()->numid : '');
                        $name = ($result->first()->customer_type=='05' ? $result->first()->name : '');
                        $foreign_country_code = ($result->first()->customer_type=='05' ? $result->first()->foreign_country_code : '');
                        $foreign_nationality = ($result->first()->customer_type=='05' ? $result->first()->foreign_nationality : '');
                        $iva_15_16 = ($result->sum('iva_15_16') > 0 ? round($result->sum('iva_15_16'),0) : '');
                        $iva_15 = ($result->sum('iva_15') > 0 ? round($result->sum('iva_15'),0) : '');
                        $iva_15_16_not = ($result->sum('iva_15_16_not') > 0 ? round($result->sum('iva_15_16_not'),0) : '');
                        $iva_10_11 = ($result->sum('iva_10_11') > 0 ? round($result->sum('iva_10_11'),0) : '');
                        $iva_10 = ($result->sum('iva_10') > 0 ? round($result->sum('iva_10'),0) : '');
                        $border_stimulation = ($result->sum('border_stimulation') > 0 ? round($result->sum('border_stimulation'),0) : '');
                        $iva_10_11_not = ($result->sum('iva_10_11_not') > 0 ? round($result->sum('iva_10_11_not'),0) : '');
                        $border_stimulation_not = ($result->sum('border_stimulation_not') > 0 ? round($result->sum('border_stimulation_not'),0) : '');
                        $foreign_iva_15_16 = ($result->sum('foreign_iva_15_16') > 0 ? round($result->sum('foreign_iva_15_16'),0) : '');
                        $foreign_iva_15_16_not = ($result->sum('foreign_iva_15_16_not') > 0 ? round($result->sum('foreign_iva_15_16_not'),0) : '');
                        $foreign_iva_10_11 = ($result->sum('foreign_iva_10_11') > 0 ? round($result->sum('foreign_iva_10_11'),0) : '');
                        $foreign_iva_10_11_not = ($result->sum('foreign_iva_10_11_not') > 0 ? round($result->sum('foreign_iva_10_11_not'),0) : '');
                        $foreign_exempt = ($result->sum('foreign_exempt') > 0 ? round($result->sum('foreign_exempt'),0) : '');
                        $iva_0 = ($result->sum('iva_0') > 0 ? round($result->sum('iva_0'),0) : '');
                        $exempt = ($result->sum('exempt') > 0 ? round($result->sum('exempt'),0) : '');
                        $iva_detained = ($result->sum('iva_detained') > 0 ? round($result->sum('iva_detained'),0) : '');
                        $iva_dev_dis_bon = ($result->sum('iva_dev_dis_bon') > 0 ? round($result->sum('iva_dev_dis_bon'),0) : '');

                        $txt .= ''.$customer_type.'|'.$operation_type.'|'.$taxid.'|'.$numid.'|'.$name.'|'.$foreign_country_code.'|'.$foreign_nationality;
                        $txt .= '|'.$iva_15_16.'|'.$iva_15.'|'.$iva_15_16_not.'|'.$iva_10_11;
                        $txt .= '|'.$iva_10.'|'.$border_stimulation.'|'.$iva_10_11_not.'|'.$border_stimulation_not;
                        $txt .= '|'.$foreign_iva_15_16.'|'.$foreign_iva_15_16_not.'|'.$foreign_iva_10_11.'|'.$foreign_iva_10_11_not;
                        $txt .= '|'.$foreign_exempt.'|'.$iva_0.'|'.$exempt.'|'.$iva_detained.'|'.$iva_dev_dis_bon. '|' . "\n";
                    }
                }else{
                    $customer_type = $result->first()->customer_type;
                    $operation_type = $result->first()->operation_type;
                    $taxid = ($result->first()->customer_type=='04' ? $result->first()->taxid : '');
                    $numid = ($result->first()->customer_type=='05' ? $result->first()->numid : '');
                    $name = ($result->first()->customer_type=='05' ? $result->first()->name : '');
                    $foreign_country_code = ($result->first()->customer_type=='05' ? $result->first()->foreign_country_code : '');
                    $foreign_nationality = ($result->first()->customer_type=='05' ? $result->first()->foreign_nationality : '');
                    $iva_15_16 = ($result->sum('iva_15_16') > 0 ? round($result->sum('iva_15_16'),0) : '');
                    $iva_15 = ($result->sum('iva_15') > 0 ? round($result->sum('iva_15'),0) : '');
                    $iva_15_16_not = ($result->sum('iva_15_16_not') > 0 ? round($result->sum('iva_15_16_not'),0) : '');
                    $iva_10_11 = ($result->sum('iva_10_11') > 0 ? round($result->sum('iva_10_11'),0) : '');
                    $iva_10 = ($result->sum('iva_10') > 0 ? round($result->sum('iva_10'),0) : '');
                    $border_stimulation = ($result->sum('border_stimulation') > 0 ? round($result->sum('border_stimulation'),0) : '');
                    $iva_10_11_not = ($result->sum('iva_10_11_not') > 0 ? round($result->sum('iva_10_11_not'),0) : '');
                    $border_stimulation_not = ($result->sum('border_stimulation_not') > 0 ? round($result->sum('border_stimulation_not'),0) : '');
                    $foreign_iva_15_16 = ($result->sum('foreign_iva_15_16') > 0 ? round($result->sum('foreign_iva_15_16'),0) : '');
                    $foreign_iva_15_16_not = ($result->sum('foreign_iva_15_16_not') > 0 ? round($result->sum('foreign_iva_15_16_not'),0) : '');
                    $foreign_iva_10_11 = ($result->sum('foreign_iva_10_11') > 0 ? round($result->sum('foreign_iva_10_11'),0) : '');
                    $foreign_iva_10_11_not = ($result->sum('foreign_iva_10_11_not') > 0 ? round($result->sum('foreign_iva_10_11_not'),0) : '');
                    $foreign_exempt = ($result->sum('foreign_exempt') > 0 ? round($result->sum('foreign_exempt'),0) : '');
                    $iva_0 = ($result->sum('iva_0') > 0 ? round($result->sum('iva_0'),0) : '');
                    $exempt = ($result->sum('exempt') > 0 ? round($result->sum('exempt'),0) : '');
                    $iva_detained = ($result->sum('iva_detained') > 0 ? round($result->sum('iva_detained'),0) : '');
                    $iva_dev_dis_bon = ($result->sum('iva_dev_dis_bon') > 0 ? round($result->sum('iva_dev_dis_bon'),0) : '');

                    $txt .= ''.$customer_type.'|'.$operation_type.'|'.$taxid.'|'.$numid.'|'.$name.'|'.$foreign_country_code.'|'.$foreign_nationality;
                    $txt .= '|'.$iva_15_16.'|'.$iva_15.'|'.$iva_15_16_not.'|'.$iva_10_11;
                    $txt .= '|'.$iva_10.'|'.$border_stimulation.'|'.$iva_10_11_not.'|'.$border_stimulation_not;
                    $txt .= '|'.$foreign_iva_15_16.'|'.$foreign_iva_15_16_not.'|'.$foreign_iva_10_11.'|'.$foreign_iva_10_11_not;
                    $txt .= '|'.$foreign_exempt.'|'.$iva_0.'|'.$exempt.'|'.$iva_detained.'|'.$iva_dev_dis_bon. '|' . "\n";
                }
            }
            $path_files = Helper::setDirectory(Diot::PATH_FILES, $diot->company_id) . '/';
            $file_txt = Str::random(40) . '.txt';
            \Storage::put($path_files . $file_txt, $txt);
            $diot->file = $file_txt;
            $diot->save();

            \DB::connection('tenant')->commit();

            //Mensaje
            flash(__('general.text_form_success_add'))->success();

            return redirect(route('diots.index'));
        } catch (\Exception $e) {

            \DB::connection('tenant')->rollback();
            flash($e->getMessage())->error();
            return back()->withInput();
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Base\Diot  $diot
     * @return \Illuminate\Http\Response
     */
    public function show(Diot $diot)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Base\Diot  $diot
     * @return \Illuminate\Http\Response
     */
    public function edit(Diot $diot)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Base\Diot  $diot
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Diot $diot)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Base\Diot  $diot
     * @return \Illuminate\Http\Response
     */
    public function destroy(Diot $diot)
    {
        //Logica
        $diot->updated_uid = \Auth::user()->id;
        $diot->status = 0;
        $diot->save();

        //Mensaje
        flash(__('general.text_form_success_delete'))->success();

        //Redireccion
        return redirect('/base/diots');
    }

    /**
     * Lista de cfdis por conciliar con banco
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws \Throwable
     */
    public function dataCfdiDownload(Request $request)
    {
        //Variables
        $year = (int)$request->year;
        $month = (int)$request->month + 1;


        //Logica
        if ($request->ajax() && !empty($year) && !empty($month)) {
            $cfdi_type = CfdiType::whereCode('I')->first();
            $filter_date_from = '01' . '-' . $month . '-' . $year; /*************Corregir de 02 a 01***************/
            $filter_date_to = \Date::createFromFormat('!d-m-Y', $filter_date_from)->endOfMonth()->format('d-m-Y');
            $diot_countries = __('general.text_diot_countries');
            $diot_customer_types = __('general.text_diot_customer_types');
            $diot_operation_types = __('general.text_diot_operation_types');

            $filter =[
                'filter_date_from' => $filter_date_from,
                'filter_date_to' => $filter_date_to,
                'filter_cfdi_type_id' => $cfdi_type->id
            ];

            //Consulta
            $cfdi_downloads = CfdiDownload::filter($filter)->where('type','=',1)->whereNotNull('uuid')->sortable('date')->get();

            $results = collect([]);
            if ($cfdi_downloads->isNotEmpty()) {
                foreach ($cfdi_downloads as $result) {
                    //
                    $path_files = Helper::setDirectory(CfdiDownload::PATH_FILES,$result->company_id) . '/';
                    $file_xml = $path_files . $result->file_xml;

                    //Obtener informacion de XML
                    $numid = '';
                    $foreign_country_code = '';
                    $foreign_nationality = '';
                    $iva_15_16 = 0;
                    $iva_15 = 0;
                    $iva_15_16_not=0;
                    $iva_10_11 = 0;
                    $iva_10 = 0;
                    $border_stimulation = 0;
                    $iva_10_11_not = 0;
                    $border_stimulation_not = 0;
                    $iva_0 = 0;
                    $exempt = 0;
                    $iva_detained = 0;
                    $iva_dev_dis_bon = 0;


                    if (!empty($file_xml)) {
                        if (\Storage::exists($file_xml) && Helper::validateXmlToArrayCfdi33($file_xml)) {
                            $xml_array = Helper::parseXmlToArrayCfdi33($file_xml);
                            if($result->rfc_emisor == 'XEXX010101000'){
                                $numid = $xml_array['data']['numid'];
                                $diot_countries_convert = __('general.text_diot_countries');
                                $foreign_country_code = isset($diot_countries_convert[$xml_array['data']['country_code']]) ? $diot_countries_convert[$xml_array['data']['country_code']] : '';
                            }
                            $tmp = Helper::parseXmlToArrayCfdi33BaseImpuestos($file_xml);
                            $iva_15_16 = $tmp['base_iva_16'] * $xml_array['data']['currency_value'];
                            $iva_15 = $tmp['base_iva_15'] * $xml_array['data']['currency_value'];
                            $iva_10_11 = $tmp['base_iva_11'] * $xml_array['data']['currency_value'];
                            $iva_10 = $tmp['base_iva_10'] * $xml_array['data']['currency_value'];
                            $border_stimulation = $tmp['base_iva_8'] * $xml_array['data']['currency_value'];
                            $iva_0 = $tmp['base_iva_0'] * $xml_array['data']['currency_value'];
                            $exempt = $tmp['base_iva_exempt'] * $xml_array['data']['currency_value'];
                            $iva_detained = $tmp['base_ret_iva'] * $xml_array['data']['currency_value'];
                            if($tmp['base_iva'] == 0){
                                $tmp = Helper::parseXmlToArrayCfdi33Impuestos($file_xml);
                                $iva_15_16 = $tmp['iva_16'] > 0 ?  $tmp['iva_16'] / 0.16 * $xml_array['data']['currency_value'] : 0;
                                $iva_15 = $tmp['iva_15'] > 0 ? $tmp['iva_16'] / 0.15 * $xml_array['data']['currency_value'] : 0;
                                $iva_10_11 = $tmp['iva_11'] > 0 ? $tmp['iva_16'] / 0.11 * $xml_array['data']['currency_value'] : 0;
                                $iva_10 = $tmp['iva_10'] > 0 ? $tmp['iva_16'] / 0.1 * $xml_array['data']['currency_value'] : 0;
                                $border_stimulation = $tmp['iva_8'] > 0 ? $tmp['iva_16'] / 0.08 * $xml_array['data']['currency_value'] : 0;
                            }
                        }
                    }

                    //
                    $customer_type = '04';
                    if($result->rfc_emisor == 'XAXX010101000'){
                        $customer_type = '15';
                    }elseif($result->rfc_emisor == 'XEXX010101000'){
                        $customer_type = '05';
                    }
                    $operation_type = '85';


                    $results[] = (object)[
                        'cfdi_download_id' => $result->id,
                        'customer_type' => $customer_type,
                        'operation_type' => $operation_type,
                        'taxid' => mb_strtoupper($result->rfc_emisor),
                        'numid' => $numid,
                        'name' => mb_strtoupper($result->emisor),
                        'name_slug' => preg_replace("/[^A-Za-z0-9]/", '', mb_strtoupper($result->emisor)),
                        'foreign_country_code' => $foreign_country_code,
                        'foreign_nationality' => $foreign_nationality,
                        'iva_15_16' => round($iva_15_16,0),
                        'iva_15' => round($iva_15,0),
                        'iva_15_16_not' => round($iva_15_16_not,0),
                        'iva_10_11' => round($iva_10_11,0),
                        'iva_10' => round($iva_10,0),
                        'border_stimulation' => round($border_stimulation,0),
                        'iva_10_11_not' => round($iva_10_11_not,0),
                        'border_stimulation_not' => round($border_stimulation_not,0),
                        'iva_0' => round($iva_0,0),
                        'exempt' => round($exempt,0),
                        'iva_detained' => round($iva_detained,0),
                        'iva_dev_dis_bon' => round($iva_dev_dis_bon,0),
                    ];
                }
                $results = collect($results);
            }

            $item_row=0;
            $html = view('layouts.partials.diots.data_cfdi_download', compact('results','item_row','diot_countries','diot_customer_types','diot_operation_types'))->render();

            return response()->json(['html' => $html,'item_row' => $results->count()+1]);
        }

        return response()->json(['error' => __('general.error_general')], 422);
    }

    /**
     * Lista de cfdis por conciliar con banco
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws \Throwable
     */
    public function addCfdiDownload(Request $request)
    {
        //Variables
        $item_row = (int)$request->item_row;


        //Logica
        if ($request->ajax() && !empty($item_row)) {

            $diot_countries = __('general.text_diot_countries');
            $diot_customer_types = __('general.text_diot_customer_types');
            $diot_operation_types = __('general.text_diot_operation_types');

            $html = view('layouts.partials.diots.add_cfdi_download', compact('item_row','diot_countries','diot_customer_types','diot_operation_types'))->render();

            return response()->json(['html' => $html,'item_row' => $item_row]);
        }

        return response()->json(['error' => __('general.error_general')], 422);
    }

    /**
     * Descarga de archivo XML
     *
     * @param Request $request
     * @param Diot $diot
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector|\Symfony\Component\HttpFoundation\BinaryFileResponse
     */
    public function downloadTxt(Request $request, Diot $diot)
    {
        //Ruta y validacion del XML
        $path_files = Helper::setDirectory(Diot::PATH_FILES,$diot->company_id) . '/';
        $file_txt = $path_files . $diot->file;
        if (!empty($file_txt)) {
            if (\Storage::exists($file_txt)) {
                while (ob_get_level()) ob_end_clean();
                ob_start();

                return response()->download(\Storage::path($file_txt), $diot->name . '.txt',['Cache-Control' => 'no-cache, must-revalidate']);
            }
        }

        //Mensaje
        flash(__('base/diot.error_download_txt'))->error();

        //Redireccion
        return redirect()->route('diots.index');
    }

    /**
     * Clase generica de impresion
     *
     * @param Diot $diot
     * @return mixed
     */
    public function print(Diot $diot)
    {
        //
        $months = __('general.text_months');
        $diot_countries = __('general.text_diot_countries');
        $diot_customer_types = __('general.text_diot_customer_types');
        $diot_operation_types = __('general.text_diot_operation_types');

        //
        $diot_line_grouped = $diot->diotLines->groupBy('name');

        //PDF
        $pdf = \PDF::loadView('base.diots.pdf', compact('diot','diot_line_grouped','months','diot_countries','diot_customer_types','diot_operation_types'))->setPaper('a4', 'landscape');

        //Redireccion
        return $pdf->stream($diot->name . '.pdf');
    }
}
