<?php

namespace App\Http\Controllers\Base;

use App\Models\Base\EmployeeCategory;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Validation\Rule;

class EmployeeCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //Variables
        $limit = ($request->has('limit') ? $request->get('limit') : 100);

        //Consulta
        $results = EmployeeCategory::filter($request->all())->sortable('general')->paginate($limit);

        //Vista
        return view('base.employee_categories.index', compact('results'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('base.employee_categories.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //Validacion
        $this->validation($request);

        //Logica
        $request->merge(['created_uid' => \Auth::user()->id]);
        $request->merge(['updated_uid' => \Auth::user()->id]);
        $request->merge(['sort_order' => (int)$request->sort_order]);
        $request->merge(['status' => 1]); //Por default activo

        //Guardar
        //Registro principal
        $employee_category = EmployeeCategory::create($request->input());

        //Mensaje
        flash(__('general.text_form_success_add'))->success();

        //Redireccion
        return redirect('/base/employee-categories');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Catalogs\EmployeeController  $employee_category
     * @return \Illuminate\Http\Response
     */
    public function show(EmployeeCategory $employee_category)
    {
        return redirect('/base/employee-categories');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Catalogs\EmployeeController  $employee_category
     * @return \Illuminate\Http\Response
     */
    public function edit(EmployeeCategory $employee_category)
    {
        return view('base.employee_categories.edit', compact('employee_category'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Catalogs\EmployeeController  $employee_category
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, EmployeeCategory $employee_category)
    {
        //Validacion
        $this->validation($request);

        //Logica
        $request->merge(['updated_uid' => \Auth::user()->id]);
        $request->merge(['sort_order' => (int)$request->sort_order]);
        $request->merge(['status' => !empty($request->status) ? 1 : 0]);
        $employee_category->fill($request->only([
            'updated_uid',
            'name',
            'sort_order',
            'status',
        ]));

        //Guardar
        //Registro principal
        $employee_category->save();

        //Mensaje
        flash(__('general.text_form_success_edit'))->success();

        //Redireccion
        return redirect('/base/employee-categories');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Catalogs\EmployeeController  $employee_category
     * @return \Illuminate\Http\Response
     */
    public function destroy(EmployeeController $employee_category)
    {
        //Logica
        $employee_category->updated_uid = \Auth::user()->id;
        $employee_category->status = 0;
        $employee_category->save();

        //Mensaje
        flash(__('general.text_form_success_delete'))->success();

        //Redireccion
        return redirect('/base/employee-categories');
    }

    /**
     * Validacion de formulario
     *
     * @param Request $request
     */
    public function validation(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|string',
        ], [
            'name.*' => __('base/employee_category.error_name'),
        ]);
    }
}
