<?php

namespace App\Http\Controllers\Base;

use App\Helpers\Helper;
use App\Models\Base\Pac;
use App\Models\Base\Setting;
use Illuminate\Http\Request;
use App\Models\Catalogs\State;
use App\Models\Catalogs\CfdiUse;
use App\Models\Catalogs\Postcode;
use App\Http\Middleware\CheckDemo;
use App\Models\Catalogs\TaxRegimen;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Crypt;
use App\Http\Middleware\CheckSuperadmin;

class SettingController extends Controller
{

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware(CheckDemo::class,['only' => ['update']]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function edit()
    {
        $setting = Setting::all()->pluck('value', 'key');
        $pacs = Pac::populateSelect()->pluck('name', 'id');

        //Datos guardados por empresa
        $setting['color_primary'] = \App\Helpers\Helper::companyColorPrimary();
        $setting['product_price_decimal_place'] = \App\Helpers\Helper::companyProductPriceDecimalPlace();
        $setting['pdf_template'] = \App\Helpers\Helper::companyPdfTemplate();
        $setting['complemento_cfdi_iedu'] = \App\Helpers\Helper::companyComplementoCfdiIedu();
        $setting['complemento_cfdi_foreign_trade'] = \App\Helpers\Helper::companyComplementoCfdiForeignTrade();
        $setting['module_customer_quotations'] = \App\Helpers\Helper::companyModuleCustomerQuotations();
        $setting['module_customer_remissions'] = \App\Helpers\Helper::companyModuleCustomerRemissions();
        $setting['modulecq_terms_of_sale'] = \App\Helpers\Helper::companyModuleCqTermOfSale();
        $setting['module_payroll'] = \App\Helpers\Helper::companyModulePayroll();
        $setting['modulepayr_legend'] = \App\Helpers\Helper::companyModulePayrLegend();

        //Vista
        return view('base.settings.edit', compact('setting','pacs'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        //Ajustes
        $request->merge(['complemento_cfdi_iedu' => !empty($request->complemento_cfdi_iedu) ? 1 : 0]);
        $request->merge(['app_demo' => !empty($request->app_demo) ? 1 : 0]);
        $request->merge(['pdf_template' => !empty($request->pdf_template) ? $request->pdf_template : 'default']);
        $request->merge(['show_product_code_on_pdf' => !empty($request->show_product_code_on_pdf) ? 1 : 0]);
        $request->merge(['folios_per_branch_office' => !empty($request->folios_per_branch_office) ? 1 : 0]);
        $request->merge(['branch_office_logo_docs' => !empty($request->branch_office_logo_docs) ? 1 : 0]);
        $request->merge(['multi_taxid' => !empty($request->multi_taxid) ? 1 : 0]);
        $request->merge(['customers_per_taxid' => !empty($request->customers_per_taxid) ? 1 : 0]);
        $request->merge(['products_per_taxid' => !empty($request->products_per_taxid) ? 1 : 0]);
        $request->merge(['disabled_folio_cart' => !empty($request->disabled_folio_cart) ? 1 : 0]);
        $request->merge(['cfdi_download' => !empty($request->cfdi_download) ? 1 : 0]);
        $request->merge(['effective_date_cfdi_download' => !empty($request->effective_date_cfdi_download) ? Helper::convertDateToSql($request->effective_date_cfdi_download) : null]);
        $request->merge(['bank_reconciliation' => !empty($request->bank_reconciliation) ? 1 : 0]);
        $request->merge(['black_list_sat' => !empty($request->black_list_sat) ? 1 : 0]);
        $request->merge(['diot' => !empty($request->diot) ? 1 : 0]);
        $request->merge(['folios_to_pay' => !empty($request->folios_to_pay) ? 1 : 0]);
        $request->merge(['validate_taxid_insigna' => !empty($request->validate_taxid_insigna) ? 1 : 0]);
        if(!empty($request->validate_taxid_insigna_password)){
            $request->merge(['validate_taxid_insigna_password' => Crypt::encryptString($request->validate_taxid_insigna_password)]);
        }else{
            $request->merge(['validate_taxid_insigna_password' => setting('validate_taxid_insigna_password','')]);
        }
        if(!empty($request->dropbox_access_token)){
            $request->merge(['dropbox_access_token' => $request->dropbox_access_token]);
        }else{
            $request->merge(['dropbox_access_token' => setting('dropbox_access_token','')]);
        }
        $request->merge(['dropbox_backup' => !empty($request->dropbox_backup) ? 1 : 0]);
        $request->merge(['complemento_cfdi_foreign_trade' => !empty($request->complemento_cfdi_foreign_trade) ? 1 : 0]);
        $request->merge(['module_customer_quotations' => !empty($request->module_customer_quotations) ? 1 : 0]);
        $request->merge(['module_customer_remissions' => !empty($request->module_customer_remissions) ? 1 : 0]);
        $request->merge(['module_payroll' => !empty($request->module_payroll) ? 1 : 0]);
        $request->merge(['enabled_projects' => !empty($request->enabled_projects) ? 1 : 0]);
        $request->merge(['projects_per_taxid' => !empty($request->projects_per_taxid) ? 1 : 0]);
        $request->merge(['projects_logo_docs' => !empty($request->projects_logo_docs) ? 1 : 0]);
        $request->merge(['disable_pedimento' => !empty($request->disable_pedimento) ? 1 : 0]);
        $request->merge(['disable_includes_iva_fix_amount_untaxed' => !empty($request->disable_includes_iva_fix_amount_untaxed) ? 1 : 0]);
        $request->merge(['add_cfd_download_to_dashboard' => !empty($request->add_cfd_download_to_dashboard) ? 1 : 0]);

        $fields = $request->all();
        //Validacion
        $skip_validate_keys = ['validate_taxid_insigna_url', 'validate_taxid_insigna_user', 'validate_taxid_insigna_password','dropbox_access_token','dropbox_folder','modulecq_terms_of_sale','modulepayr_legend','effective_date_cfdi_download', 'qty_cfdi_download'];
        foreach ($fields as $key => $value) {
            if (in_array($key, $skip_validate_keys)) {
                continue;
            }
            if (empty($value) && $value != '0') {
                flash(__('base/setting.error_empty_field') . ' ('.$key.')')->error();
                return back()->withInput();
            }
        }

        $superadmin_keys = ['multi_taxid','customers_per_taxid','products_per_taxid','cfdi_version','default_pac_id','app_demo','disabled_folio_cart','cfdi_download','effective_date_cfdi_download','bank_reconciliation','black_list_sat','diot','folios_to_pay', 'qty_cfdi_download'];
        $skip_keys = ['_method', '_token','login_iframe'];
        $file_keys = [];
        $company_keys = ['color_primary','product_price_decimal_place','pdf_template','complemento_cfdi_iedu','complemento_cfdi_foreign_trade','module_customer_quotations','module_customer_remissions','modulecq_terms_of_sale','module_payroll','modulepayr_legend'];

        //Datos guardados por empresa
        $company = Helper::defaultCompany();

        //Logica
        foreach ($fields as $key => $value) {
            // Campos no procesados
            if (in_array($key, $skip_keys)) {
                continue;
            }

            if(!\Auth::user()->superadmin) {
                // Campos no procesados
                if (in_array($key, $superadmin_keys)) {
                    continue;
                }
            }

            // Subir archivos
            if (in_array($key, $file_keys)) {

                // Prevent reset
                if (empty($value)) {
                    continue;
                }
            }

            //Datos guardados por empresa
            if (in_array($key, $company_keys)) {
                $company->$key = $value;
                continue;
            }

            if(empty($value) && $value != '0'){
                setting()->set($key, '');
            }else {
                setting()->set($key, $value);
            }
        }

        //Datos guardados por empresa
        $company->save();

        //Guardar
        setting()->save();

        //actualiza
        if(setting('cfdi_version') == 'cfdi33')
        {
            $cfdi_uses = CfdiUse::whereIn('code', ['P01'])->update([
                'status' => '1'
            ]);
            $cfdi_uses = CfdiUse::whereIn('code', ['S01','CP01','CN01'])->update([
                'status' => '0'
            ]);
            State::whereIn('code', ['CMX'])->update([
                'code' => 'DIF'
            ]);
            Postcode::whereIn('code_state', ['CMX'])->update([
                'code_state' => 'DIF'
            ]);
        }
        if(setting('cfdi_version') == 'cfdi40')
        {
            $cfdi_uses = CfdiUse::whereIn('code', ['P01'])->update([
                'status' => '0'
            ]);
            $cfdi_uses = CfdiUse::whereIn('code', ['S01','CP01','CN01'])->update([
                'status' => '1'
            ]);

            $tax_regimens = TaxRegimen::whereIn('code', ['616'])->update([
                'status' => '1'
            ]);
            State::whereIn('code', ['DIF'])->update([
                'code' => 'CMX'
            ]);
            Postcode::whereIn('code_state', ['DIF'])->update([
                'code_state' => 'CMX'
            ]);
        }

        //Mensaje
        flash(__('general.text_form_success_edit'))->success();

        if(!empty($request->folios_per_branch_office)){
            flash(sprintf(__('base/setting.text_alert_folios_per_branch_office'),route('document-types.index')))->info();
        }

        //Redireccion
        return redirect('/home');
    }

}
