<?php

namespace App\Http\Controllers\Catalogs;

use App\Models\Catalogs\ExpenseType;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Validation\Rule;

class ExpenseTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //Variables
        $limit = ($request->has('limit') ? $request->get('limit') : 100);

        //Consulta
        $results =ExpenseType::filter($request->all())->sortable('general')->paginate($limit);

        //Vista
        return view('catalogs.expense_types.index', compact('results'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('catalogs.expense_types.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //Validacion
        $this->validation($request);

        //Logica
        $request->merge(['created_uid' => \Auth::user()->id]);
        $request->merge(['updated_uid' => \Auth::user()->id]);
        $request->merge(['sort_order' => (int)$request->sort_order]);
        $request->merge(['status' => 1]); //Por default activo

        //Guardar
        //Registro principal
        $expense_type= ExpenseType::create($request->input());

        //Mensaje
        flash(__('general.text_form_success_add'))->success();

        //Redireccion
        return redirect('/catalogs/expense-types');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Catalogs\ExpenseType  $expense_type
     * @return \Illuminate\Http\Response
     */
    public function show(ExpenseType $expense_type)
    {
        return redirect('/catalogs/expense-types');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Catalogs\ExpenseType  $expense_type
     * @return \Illuminate\Http\Response
     */
    public function edit(ExpenseType $expense_type)
    {
        return view('catalogs.expense_types.edit', compact('expense_type'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Catalogs\ExpenseType  $expense_type
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ExpenseType $expense_type)
    {
        //Validacion
        $this->validation($request);

        //Logica
        $request->merge(['updated_uid' => \Auth::user()->id]);
        $request->merge(['sort_order' => (int)$request->sort_order]);
        $request->merge(['status' => !empty($request->status) ? 1 : 0]);
        $expense_type->fill($request->only([
            'updated_uid',
            'name',
            'type',
            'sort_order',
            'status',
        ]));

        //Guardar
        //Registro principal
        $expense_type->save();

        //Mensaje
        flash(__('general.text_form_success_edit'))->success();

        //Redireccion
        return redirect('/catalogs/expense-types');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Catalogs\ExpenseType  $expense_type
     * @return \Illuminate\Http\Response
     */
    public function destroy(ExpenseType $expense_type)
    {
        //Logica
        $expense_type->updated_uid = \Auth::user()->id;
        $expense_type->status = 0;
        $expense_type->save();

        //Mensaje
        flash(__('general.text_form_success_delete'))->success();

        //Redireccion
        return redirect('/catalogs/expense-types');
    }
    /**
     * Validacion de formulario
     *
     * @param Request $request
     */
    public function validation(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|string',
        ], [
            'name.*' => __('catalogs/expense_type.error_name'),
        ]);
    }
}
