<?php

namespace App\Http\Controllers\Catalogs;

use App\Models\Catalogs\IeduNivelEducativo;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class IeduNivelEducativoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //Variables
        $limit = ($request->has('limit') ? $request->get('limit') : 100);

        //Consulta
        $results =IeduNivelEducativo::filter($request->all())->sortable('name')->paginate($limit);

        //Vista
        return view('catalogs.iedu_nivel_educativos.index', compact('results'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('catalogs.iedu_nivel_educativos.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //Validacion
        $this->validation($request);

        //Logica
        $request->merge(['created_uid' => \Auth::user()->id]);
        $request->merge(['updated_uid' => \Auth::user()->id]);
        $request->merge(['sort_order' => (int)$request->sort_order]);
        $request->merge(['status' => 1]); //Por default activo

        //Guardar
        //Registro principal
        $iedu_nivel_educativo= IeduNivelEducativo::create($request->input());

        //Mensaje
        flash(__('general.text_form_success_add'))->success();

        //Redireccion
        return redirect('/catalogs/iedu-nivel-educativos');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Catalogs\IeduNivelEducativo  $iedu_nivel_educativo
     * @return \Illuminate\Http\Response
     */
    public function show(IeduNivelEducativo $iedu_nivel_educativo)
    {
        return redirect('/catalogs/iedu-nivel-educativos');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Catalogs\IeduNivelEducativo  $iedu_nivel_educativo
     * @return \Illuminate\Http\Response
     */
    public function edit(IeduNivelEducativo $iedu_nivel_educativo)
    {
        return view('catalogs.iedu_nivel_educativos.edit', compact('iedu_nivel_educativo'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Catalogs\IeduNivelEducativo  $iedu_nivel_educativo
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, IeduNivelEducativo $iedu_nivel_educativo)
    {
        //Validacion
        $this->validation($request);

        //Logica
        $request->merge(['updated_uid' => \Auth::user()->id]);
        $request->merge(['sort_order' => (int)$request->sort_order]);
        $request->merge(['status' => !empty($request->status) ? 1 : 0]);
        $iedu_nivel_educativo->fill($request->only([
            'updated_uid',
            'name',
            'code',
            'aut_rvoe',
            'sort_order',
            'status',
        ]));

        //Guardar
        //Registro principal
        $iedu_nivel_educativo->save();

        //Mensaje
        flash(__('general.text_form_success_edit'))->success();

        //Redireccion
        return redirect('/catalogs/iedu-nivel-educativos');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Catalogs\IeduNivelEducativo  $iedu_nivel_educativo
     * @return \Illuminate\Http\Response
     */
    public function destroy(IeduNivelEducativo $iedu_nivel_educativo)
    {
        //Logica
        $iedu_nivel_educativo->updated_uid = \Auth::user()->id;
        $iedu_nivel_educativo->status = 0;
        $iedu_nivel_educativo->save();

        //Mensaje
        flash(__('general.text_form_success_delete'))->success();

        //Redireccion
        return redirect('/catalogs/iedu-nivel-educativos');
    }

    /**
     * Validacion de formulario
     *
     * @param Request $request
     */
    public function validation(Request $request)
    {
        $this->validate($request, [
            'name' => 'required',
            'code' => 'required',
            'aut_rvoe' => 'required',
        ], [
            'name.*' => __('catalogs/iedu_nivel_educativo.error_name'),
            'code.*' => __('catalogs/iedu_nivel_educativo.error_code'),
            'aut_rvoe.*' => __('catalogs/iedu_nivel_educativo.error_aut_rvoe'),
        ]);
    }
}
