<?php

namespace App\Http\Controllers\Catalogs;

use App\Models\Catalogs\OperationalType;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Validation\Rule;

class OperationalTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //Variables
        $limit = ($request->has('limit') ? $request->get('limit') : 100);

        //Consulta
        $results =OperationalType::filter($request->all())->sortable('general')->paginate($limit);

        //Vista
        return view('catalogs.operational_types.index', compact('results'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('catalogs.operational_types.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //Validacion
        $this->validation($request);

        //Logica
        $request->merge(['created_uid' => \Auth::user()->id]);
        $request->merge(['updated_uid' => \Auth::user()->id]);
        $request->merge(['sort_order' => (int)$request->sort_order]);
        $request->merge(['status' => 1]); //Por default activo

        //Guardar
        //Registro principal
        $operational_type= OperationalType::create($request->input());

        //Mensaje
        flash(__('general.text_form_success_add'))->success();

        //Redireccion
        return redirect('/catalogs/operational-types');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Catalogs\OperationalType  $operational_type
     * @return \Illuminate\Http\Response
     */
    public function show(OperationalType $operational_type)
    {
        return redirect('/catalogs/operational-types');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Catalogs\OperationalType  $operational_type
     * @return \Illuminate\Http\Response
     */
    public function edit(OperationalType $operational_type)
    {
        return view('catalogs.operational_types.edit', compact('operational_type'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Catalogs\OperationalType  $operational_type
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, OperationalType $operational_type)
    {
        //Validacion
        $this->validation($request);

        //Logica
        $request->merge(['updated_uid' => \Auth::user()->id]);
        $request->merge(['sort_order' => (int)$request->sort_order]);
        $request->merge(['status' => !empty($request->status) ? 1 : 0]);
        $operational_type->fill($request->only([
            'updated_uid',
            'name',
            'sort_order',
            'status',
        ]));

        //Guardar
        //Registro principal
        $operational_type->save();

        //Mensaje
        flash(__('general.text_form_success_edit'))->success();

        //Redireccion
        return redirect('/catalogs/operational-types');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Catalogs\OperationalType  $operational_type
     * @return \Illuminate\Http\Response
     */
    public function destroy(OperationalType $operational_type)
    {
        //Logica
        $operational_type->updated_uid = \Auth::user()->id;
        $operational_type->status = 0;
        $operational_type->save();

        //Mensaje
        flash(__('general.text_form_success_delete'))->success();

        //Redireccion
        return redirect('/catalogs/operational-types');
    }
    /**
     * Validacion de formulario
     *
     * @param Request $request
     */
    public function validation(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|string',
        ], [
            'name.*' => __('catalogs/operational_type.error_name'),
        ]);
    }
}
