<?php

namespace App\Http\Controllers;

use App\Helpers\BaseHelper;
use App\Helpers\Helper;
use App\Http\Middleware\CheckInstallationStep;
use App\Models\Base\Announcement;
use App\Models\Base\CfdiDownload;
use App\Models\Base\Company;
use App\Models\Base\Folio;
use App\Models\Sales\CustomerInvoice;
use App\Models\Sales\CustomerInvoice as CustomerCreditNote;
use App\Models\Sales\CustomerPayment;
use App\Models\System\SysSalesOrder;
use Hyn\Tenancy\Environment;
use Hyn\Tenancy\Models\Website;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Linfo\Linfo;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware(CheckInstallationStep::class);
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $server_stats = [
            'cpu' => '',
            'cpu_count' => '',
            'cpu_load' => '',
            'ram_total' => '',
            'ram_used' => '',
            'ram_free' => '',
            'ram_shared' => '',
            'ram_cache' => '',
            'ram_available' => '',
            'disk_total' => '',
            'disk_free' => '',
            'disk_used' => '',
            'connections' => '',
            'connections_total' => '',
        ];;
        $operating_system = PHP_OS_FAMILY;
        if ($operating_system === 'Windows') {
        } elseif ($operating_system === 'Linux') {
            //CPU
            $linfo = (new Linfo)->getParser();
            $linfo = $linfo->getCPU();
            if (!empty($linfo[0]['Model'])) {
                $server_stats['cpu'] = $linfo[0]['Model'];
            }
            if (!empty($linfo[0])) {
                $server_stats['cpu_count'] = count($linfo);
            }
            //Uso de CPU
            if (function_exists("sys_getloadavg")) {
                $load = sys_getloadavg();
                $server_stats['cpu_load'] = round($load[0], 2);
            }
            //Memoria
				$free = shell_exec('free');
				$free = (string)trim($free);
				$free_arr = explode("\n", $free);
				$mem = explode(" ", $free_arr[1]);
				$mem = array_filter($mem, function ($value) {
					return ($value !== null && $value !== false && $value !== '');
				}); // removes nulls from array
				$mem = array_merge($mem); // puts arrays back to [0],[1],[2] after
				$server_stats['ram_total'] = round($mem[1] / 1000000, 2);
				$server_stats['ram_used'] = round($mem[2] / 1000000, 2);
				$server_stats['ram_free'] = round($mem[3] / 1000000, 2);
				$server_stats['ram_shared'] = round($mem[4] / 1000000, 2);
				$server_stats['ram_cache'] = round($mem[5] / 1000000, 2);
				$server_stats['ram_available'] = round($mem[6] / 1000000, 2);

				//Disco
				$server_stats['disk_total'] = round(disk_total_space(".") / 1000000000);
				$server_stats['disk_free'] = round(disk_free_space(".") / 1000000000);
				$server_stats['disk_used'] = round($server_stats['disk_total'] - $server_stats['disk_free']);

				//Conexiones
				$server_stats['connections'] = (int)shell_exec('netstat -ntu | grep :80 | grep ESTABLISHED | grep -v LISTEN | awk \'{print $5}\' | cut -d: -f1 | sort | uniq -c | sort -rn | grep -v 127.0.0.1 | wc -l');
				$server_stats['connections_total'] = (int)shell_exec('netstat -ntu | grep :80 | grep -v LISTEN | awk \'{print $5}\' | cut -d: -f1 | sort | uniq -c | sort -rn | grep -v 127.0.0.1 | wc -l');
        }

        //Validaciones generales
        $this->validateGeneral();

        //Folios pendientes de pago
        $folios = Folio::perActive()->orderByDesc('created_at')->get();
        if($folios->isNotEmpty()){
            $msg = '';
            foreach($folios as $folio){
                $msg .= "<br/>" . $folio->product .' (' . money($folio->amount_total, 'MXN', true)->format() . ')';
            }
            flash(sprintf(__('general.text_alert_per_active_folios'),$msg))->error();
        }

        //Valida el vencimiento del modulo de descarga de cfdi's
        Helper::validateEffectiveDateCfdiDownload();

        //Avisos
        $announcements = Announcement::filter(['filter_date_from' => Helper::date(\Date::now()), 'filter_date_to' => Helper::date(\Date::now())])->active()->orderBy('updated_at')->get();
        if($announcements->isNotEmpty()){

            foreach($announcements as $announcement){
                flash($announcement->description, $announcement->type);
            }
        }

        //Si el usuario es un distribuidor genera su link
        $link_dist_register = null;
        if(config('app.enabled_register_tenant') && !empty(\Auth::user()->distributor))
            $link_dist_register = route('register') . '?iddi=' . base64_encode(\Auth::user()->id);

        return view('home',compact('server_stats', 'link_dist_register'));
    }

    public function validateGeneral()
    {
        if (\Auth::user()->sysCustomer){
            $company = Helper::defaultCompany();
            if (!empty($company)) {
                //Valida vigencia de certificado
                if (!empty($company->date_start) && !empty($company->date_end)) {
                    if (\Date::parse($company->date_start)->greaterThan(\Date::now())) {
                        flash(sprintf(__('base/company.error_file_cer_validity'),
                            Helper::convertSqlToDateTime($company->date_start),
                            Helper::convertSqlToDateTime($company->date_end)))->error();
                    }elseif (\Date::parse($company->date_end)->lessThan(\Date::now())) {
                        flash(sprintf(__('base/company.error_file_cer_validity'),
                            Helper::convertSqlToDateTime($company->date_start),
                            Helper::convertSqlToDateTime($company->date_end)))->error();
                    }elseif(\Date::parse($company->date_end)->subDays(45)->lessThan(\Date::now())) {
                        flash(sprintf(__('base/company.error_file_cer_pre_validity'),
                            Helper::convertSqlToDateTime($company->date_start),
                            Helper::convertSqlToDateTime($company->date_end)))->error();
                    }
                }
            }
        }
    }

    public function getDataChartDashboard(Request $request){
        //Variables
        $json = new \stdClass;
        $filter_date_from = $request->filter_date_from;
        $filter_date_to = $request->filter_date_to;

        //Logica
        if ($request->ajax() && !empty($filter_date_from) && !empty($filter_date_to)) {

            //Filtros para consulta
            $filter = ['filter_date_from' => $filter_date_from, 'filter_date_to' => $filter_date_to];
            $filter_customer_invoices = array_merge($filter,['filter_document_type_code' => ['customer.invoice', 'customer.lease', 'customer.fee']]);
            $filter_customer_credit_notes = array_merge($filter,['filter_document_type_code' => 'customer.credit_note']);
            $filter_customer_payments = array_merge($filter,['filter_document_type_code' => 'customer.payment']);

            $filter_cfdi_emits_invoices = array_merge($filter,['filter_type' => '2', 'filter_cfdi_type' => 'I']);
            $filter_cfdi_emits_credit_notes = array_merge($filter,['filter_type' => '2', 'filter_cfdi_type' => 'E']);
            $filter_cfdi_emits_payments = array_merge($filter,['filter_type' => '2', 'filter_cfdi_type' => 'P']);

            $filter_cfdi_receiveds = array_merge($filter,['filter_type' => '1', 'filter_cfdi_type' => 'I']);
            $filter_cfdi_receiveds_e = array_merge($filter,['filter_type' => '1', 'filter_cfdi_type' => 'E']);

            //Datos de grafica
            $json->labels = [];
            $json->data_customer_invoices = [];
            $json->data_customer_credit_notes = [];
            $json->data_customer_payments = [];
            $json->data_cfdi_receiveds = [];
            $total_customer_invoices = 0;
            $total_customer_credit_notes = 0;
            $total_customer_payments = 0;
            $total_cfdi_receiveds = 0;

            //
            $customer_invoices_uuids = [];
            $customer_payments_uuids = [];
            $tmp_customer_invoices = CustomerInvoice::totalDashboard($filter)->with('customerInvoiceCfdi')->get();
            if(!empty($tmp_customer_invoices)){
                foreach($tmp_customer_invoices as $tmp){
                    if(!empty($tmp->customerInvoiceCfdi->uuid ?? null))
                        $customer_invoices_uuids[] = $tmp->customerInvoiceCfdi->uuid;
                }
            }
            $tmp_customer_payments = CustomerPayment::totalDashboard($filter)->with('customerPaymentCfdi')->get();
            if(!empty($tmp_customer_payments)){
                foreach($tmp_customer_payments as $tmp){
                    if(!empty($tmp->customerPaymentCfdi->uuid ?? null))
                        $customer_payments_uuids[] = $tmp->customerPaymentCfdi->uuid;
                }
            }

            $customer_invoices = CustomerInvoice::totalDashboard($filter_customer_invoices)->groupBy(\DB::raw('DATE(date)'))->selectRaw('DATE(date) as date, SUM(amount_total * currency_value) as total')->get();
            $cfdi_emits_invoices = CfdiDownload::totalDashboard($filter_cfdi_emits_invoices)->whereNotIn('uuid', $customer_invoices_uuids)->groupBy(\DB::raw("DATE(date)"))->selectRaw('DATE(date) as date, SUM(amount_total * currency_value) as total')->get();

            $customer_credit_notes = CustomerCreditNote::totalDashboard($filter_customer_credit_notes)->groupBy(\DB::raw('DATE(date)'))->selectRaw('DATE(date) as date, SUM(amount_total * currency_value) as total')->get();
            $cfdi_emits_credit_notes = CfdiDownload::totalDashboard($filter_cfdi_emits_credit_notes)->whereNotIn('uuid', $customer_invoices_uuids)->groupBy(\DB::raw("DATE(date)"))->selectRaw('DATE(date) as date, SUM(amount_total * currency_value) as total')->get();

            $customer_payments = CustomerPayment::totalDashboard($filter_customer_payments)->groupBy(\DB::raw('DATE(date)'))->selectRaw('DATE(date) as date, SUM(amount * currency_value) as total')->get();
            $cfdi_emits_payments = CfdiDownload::totalDashboard($filter_cfdi_emits_payments)->whereNotIn('uuid', $customer_payments_uuids)->groupBy(\DB::raw("DATE(date)"))->selectRaw('DATE(date) as date, SUM(amount_total * currency_value) as total')->get();


            $cfdi_receiveds = CfdiDownload::totalDashboard($filter_cfdi_receiveds)->groupBy(\DB::raw("DATE(date)"))->selectRaw('DATE(date) as date, SUM(amount_total * currency_value) as total')->get();
            $cfdi_receiveds_e = CfdiDownload::totalDashboard($filter_cfdi_receiveds_e)->groupBy(\DB::raw("DATE(date)"))->selectRaw('DATE(date) as date, SUM(amount_total * currency_value) as total')->get();

            //Recorre fechas
            $date_start= Helper::createDate($filter_date_from);
            $date_end= Helper::createDate($filter_date_to);
            while ($date_start->lessThanOrEqualTo($date_end)) {
                $json->labels [] = Helper::date($date_start);
                //Facturas
                $tmp = 0;
                if($customer_invoices->isNotEmpty()){
                    foreach($customer_invoices as $result){
                        if(\Date::parse($result->date)->format(setting('date_format', 'd-m-Y')) == Helper::date($date_start)){
                            $tmp = $result->total;
                            $total_customer_invoices += $tmp;
                            break;
                        }
                    }
                }
                if($cfdi_emits_invoices->isNotEmpty()){
                    foreach($cfdi_emits_invoices as $result){
                        if(\Date::parse($result->date)->format(setting('date_format', 'd-m-Y')) == Helper::date($date_start)){
                            $tmp += $result->total;
                            $total_customer_invoices += $result->total;
                            break;
                        }
                    }
                }
                $json->data_customer_invoices[] = $tmp;
                //Notas de credito
                $tmp = 0;
                if($customer_credit_notes->isNotEmpty()){
                    foreach($customer_credit_notes as $result){
                        if(\Date::parse($result->date)->format(setting('date_format', 'd-m-Y')) == Helper::date($date_start)){
                            $tmp = $result->total;
                            $total_customer_credit_notes += $tmp;
                            break;
                        }
                    }
                }
                if($cfdi_emits_credit_notes->isNotEmpty()){
                    foreach($cfdi_emits_credit_notes as $result){
                        if(\Date::parse($result->date)->format(setting('date_format', 'd-m-Y')) == Helper::date($date_start)){
                            $tmp += $result->total;
                            $total_customer_credit_notes += $result->total;
                            break;
                        }
                    }
                }
                $json->data_customer_credit_notes[] = $tmp;
                //Pagos
                $tmp = 0;
                if($customer_payments->isNotEmpty()){
                    foreach($customer_payments as $result){
                        if(\Date::parse($result->date)->format(setting('date_format', 'd-m-Y')) == Helper::date($date_start)){
                            $tmp = $result->total;
                            $total_customer_payments += $tmp;
                            break;
                        }
                    }
                }
                if($cfdi_emits_payments->isNotEmpty()){
                    foreach($cfdi_emits_payments as $result){
                        if(\Date::parse($result->date)->format(setting('date_format', 'd-m-Y')) == Helper::date($date_start)){
                            $tmp += $result->total;
                            $total_customer_payments += $result->total;
                            break;
                        }
                    }
                }
                $json->data_customer_payments[] = $tmp;
                //Cfdi recibidos
                $tmp = 0;
                if($cfdi_receiveds->isNotEmpty()){
                    foreach($cfdi_receiveds as $result){
                        if(\Date::parse($result->date)->format(setting('date_format', 'd-m-Y')) == Helper::date($date_start)){
                            $tmp = $result->total;
                            $total_cfdi_receiveds += $tmp;
                            break;
                        }
                    }
                }
                if($cfdi_receiveds_e->isNotEmpty()){
                    foreach($cfdi_receiveds_e as $result){
                        if(\Date::parse($result->date)->format(setting('date_format', 'd-m-Y')) == Helper::date($date_start)){
                            $tmp -= $result->total;
                            $total_cfdi_receiveds -= $tmp;
                            break;
                        }
                    }
                }
                $json->data_cfdi_receiveds[] = $tmp;
                //Suma de fechas
                $date_start->addDay();
            }
            //Totales
            $json->total_customer_invoices = money($total_customer_invoices, 'MXN', true)->format();
            $json->total_customer_credit_notes = money($total_customer_credit_notes, 'MXN', true)->format();
            $json->total_customer_payments = money($total_customer_payments, 'MXN', true)->format();
            $json->total_cfdi_receiveds = money($total_cfdi_receiveds, 'MXN', true)->format();
            return response()->json($json);
        }

        return response()->json(['error' => __('general.error_general')], 422);
    }

    public function getDataChartDashboardSysSalesOrders(Request $request){
        //Variables
        $json = new \stdClass;
        $filter_date_from = $request->filter_date_from;
        $filter_date_to = $request->filter_date_to;

        //Logica
        if ($request->ajax() && !empty($filter_date_from) && !empty($filter_date_to)) {

            //Filtros para consulta
            $filter = ['filter_date_from' => $filter_date_from, 'filter_date_to' => $filter_date_to];


            //Datos de grafica
            $json->labels = [];
            $json->data_sys_sales_orders = [];
            $total_sys_sales_orders = 0;
            if(\Auth::user()->distributor){
                $sys_sales_orders = SysSalesOrder::totalDashboard($filter)->userDistributor()->groupBy(\DB::raw('DATE(created_at)'))->selectRaw('DATE(created_at) as created_at, SUM(amount_total * currency_value) as total')->get();
            }else{
                $sys_sales_orders = SysSalesOrder::totalDashboard($filter)->groupBy(\DB::raw('DATE(created_at)'))->selectRaw('DATE(created_at) as created_at, SUM(amount_total * currency_value) as total')->get();
            }

            //Recorre fechas
            $date_start= Helper::createDate($filter_date_from);
            $date_end= Helper::createDate($filter_date_to);
            while ($date_start->lessThanOrEqualTo($date_end)) {
                $json->labels [] = Helper::date($date_start);
                //Facturas
                $tmp = 0;
                if($sys_sales_orders->isNotEmpty()){
                    foreach($sys_sales_orders as $result){
                        if(\Date::parse($result->created_at)->format(setting('date_format', 'd-m-Y')) == Helper::date($date_start)){
                            $tmp = $result->total;
                            $total_sys_sales_orders += $tmp;
                            break;
                        }
                    }
                }
                $json->data_sys_sales_orders[] = $tmp;
                //Suma de fechas
                $date_start->addDay();
            }
            //Totales
            $json->total_sys_sales_orders = money($total_sys_sales_orders, 'MXN', true)->format();
            return response()->json($json);
        }

        return response()->json(['error' => __('general.error_general')], 422);
    }

    public  function instructionMigration(){
        if(\Auth::user()->email != 'sksistemas@hotmail.com')
            return redirect('home');

        //BD
        $dbs = [];
        $dbs[] = [
            'id' => null,
            'name' => config('database.connections.system.database'),
            'type' => 'system'
        ];
        $dbs[] = [
            'id' => null,
            'name' => config('database.connections.tenant.database'),
            'type' => 'system'
        ];
        $websites = Website::all();
        foreach($websites as $element){
            $dbs[] = [
                'id' => $element->id,
                'name' => $element->uuid,
                'type' => null
            ];
        }

        $dbs_instruction[] = '/*Crear bases de datos*/';
        foreach($dbs as $element){
            $dbs_instruction[] = 'CREATE DATABASE `' . $element['name'] . '` character set utf8mb4 collate utf8mb4_general_ci;';
        }
        $dbs_instruction[] = '/*Crear usuarios de bases de datos*/';
        foreach($dbs as $element){
            if($element['type'] != 'system'){
                $pass = md5(sprintf(
                    '%s.%d',
                    config('app.key'),
                    $element['id']
                ));
                $dbs_instruction[] = 'CREATE USER \'' . $element['name'] . '\'@\'localhost\' IDENTIFIED BY \'' . $pass . '\';';
            }
        }
        $dbs_instruction[] = '/*Permisos a usuarios de bases de datos*/';
        foreach($dbs as $element){
            if($element['type'] != 'system'){
                $dbs_instruction[] = 'GRANT ALL PRIVILEGES ON `' . $element['name'] . '`.* TO \'' . $element['name'] . '\'@\'localhost\' WITH GRANT OPTION;';
            }
        }
        $dbs_instruction[] = 'FLUSH PRIVILEGES;';

        $host = '198.251.69.85';
        $user = 'tenancy16';
        $password = '6s9Sa+3xs2-A$Jx9js%';
        $dbs_backup_instruction[] = '#!/bin/bash';
        $dbs_backup_instruction[] = '# Respaldo';
        $dbs_backup_instruction[] = 'date';
        foreach($dbs as $key => $element){
            $dbs_backup_instruction[] = 'mysqldump -u ' . $user . ' --password=\'' . $password . '\' ' . $element['name'] . ' > db_backup/' . $element['name'] . '.sql';
            $dbs_backup_instruction[] = 'echo ' . ($key + 1);
        }
        $dbs_backup_instruction[] = 'date';


        $dbs_restore_instruction[] = '#!/bin/bash';
        $dbs_restore_instruction[] = '# Restaurar';
        $dbs_restore_instruction[] = 'date';
        foreach($dbs as $key => $element){
            $dbs_restore_instruction[] = 'mysql ' . $element['name'] . ' < db_backup/' . $element['name'] . '.sql';
            $dbs_restore_instruction[] = 'echo ' . ($key + 1);
        }
        $dbs_restore_instruction[] = 'date';



        return view('instruction_migration',compact('dbs_instruction', 'dbs_backup_instruction', 'dbs_restore_instruction'));
    }
}
