<?php

namespace App\Http\Controllers\Reports;

use App\Helpers\Helper;
use Illuminate\Http\Request;
use App\Models\Base\CfdiDownload;
use App\Http\Controllers\Controller;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\IncomeExpensesExport;
use App\Models\Sales\CustomerInvoice;
use App\Models\Sales\CustomerRemission;

class IncomeExpensesController extends Controller
{
    /**
     * Reporte
     *
     * @param Request $request
     */
    public function index(Request $request)
    {
        $year = empty($request->filter_year) ? \Date::now()->format('Y') : $request->filter_year;
        $customer_remission_includes = __('general.text_customer_remission_includes');
        if (empty($request->filter_year)) {
            $request->request->add([
                'filter_year' => $year
            ]);
        }
        //
        $years = [];
        $year_tmp = \Date::now()->format('Y');
        for($i = ($year_tmp-7);$i <= $year_tmp;$i++){
            $years[$i] = $i;
        }
        //
        $results = $this->generateData($year, $request->filter_customer_remission_include);

        return view('reports.income_expenses.index',compact('results', 'years', 'customer_remission_includes'));
    }

    /**
     * Exportar datos a excel
     *
     * @param Request $request
     * @return \Symfony\Component\HttpFoundation\BinaryFileResponse
     */
    public function exportToExcel(Request $request)
    {
        $year = empty($request->filter_year) ? \Date::now()->format('Y') : $request->filter_year;
        $results = $this->generateData($year, $request->customer_remission_include);
        $results = array_map(function ($item){
            unset($item->style);
            $item->income_amount_untaxed = str_replace(['$',','],'',$item->income_amount_untaxed);
            $item->income_amount_iva = str_replace(['$',','],'',$item->income_amount_iva);
            $item->income_amount_ieps = str_replace(['$',','],'',$item->income_amount_ieps);
            $item->income_amount_ret_iva = str_replace(['$',','],'',$item->income_amount_ret_iva);
            $item->income_amount_ret_isr = str_replace(['$',','],'',$item->income_amount_ret_isr);
            $item->income_amount_total = str_replace(['$',','],'',$item->income_amount_total);
            $item->expenses_amount_untaxed = str_replace(['$',','],'',$item->expenses_amount_untaxed);
            $item->expenses_amount_iva = str_replace(['$',','],'',$item->expenses_amount_iva);
            $item->expenses_amount_ieps = str_replace(['$',','],'',$item->expenses_amount_ieps);
            $item->expenses_amount_ret_iva = str_replace(['$',','],'',$item->expenses_amount_ret_iva);
            $item->expenses_amount_ret_isr = str_replace(['$',','],'',$item->expenses_amount_ret_isr);
            $item->expenses_amount_total = str_replace(['$',','],'',$item->expenses_amount_total);
            return $item;
        }, $results);

        while (ob_get_level()) ob_end_clean();
        ob_start();

        return Excel::download(new IncomeExpensesExport($results),__('reports/income_expenses.document_title') . '-' . config('app.name') . '.xlsx');
    }

    private function generateData($year, $customer_remission_include, $format = true){
        $text_months = __('general.text_months');
        //
        $data = [];
        $totales = (object)[
            'income' => (object)[
                'amount_untaxed' => 0,
                'amount_iva' => 0,
                'amount_ieps' => 0,
                'amount_ret_iva' => 0,
                'amount_ret_isr' => 0,
                'amount_total' => 0,
            ],
            'expenses' => (object)[
                'amount_untaxed' => 0,
                'amount_iva' => 0,
                'amount_ieps' => 0,
                'amount_ret_iva' => 0,
                'amount_ret_isr' => 0,
                'amount_total' => 0,
            ]
        ];
        for($month = 1; $month <= 12; $month++){
            $element = (object)[
                'income' => (object)[
                    'amount_untaxed' => 0,
                    'amount_iva' => 0,
                    'amount_ieps' => 0,
                    'amount_ret_iva' => 0,
                    'amount_ret_isr' => 0,
                    'amount_total' => 0,
                ],
                'expenses' => (object)[
                    'amount_untaxed' => 0,
                    'amount_iva' => 0,
                    'amount_ieps' => 0,
                    'amount_ret_iva' => 0,
                    'amount_ret_isr' => 0,
                    'amount_total' => 0,
                ]
            ];

            //Logica
            if(!in_array($customer_remission_include, ['2'])){
                $results = CustomerInvoice::totalDashboard(
                    ['filter_document_type_code' => ['customer.invoice', 'customer.lease', 'customer.fee', 'customer.credit_note']]
                )
                ->whereMonth('date', '=', $month)
                ->whereYear('date', '=', $year)
                ->with('documentType')
                ->with('customerInvoiceCfdi')
                ->get();
                if($results->isNotEmpty()){
                    foreach($results as $result){
                        $td = $result->documentType->code == 'customer.credit_note' ? (-1) : 1;
                        $untaxed = $result->amount_untaxed * $result->currency_value * $td;
                        $total = $result->amount_total * $result->currency_value * $td;
                        $iva = 0;
                        $ieps = 0;
                        $ret_iva = 0;
                        $ret_isr = 0;
                        //
                        $path_files = $result->documentType->code == 'customer.credit_note' ? CustomerInvoice::PATH_XML_FILES_CCN : ($result->documentType->code == 'customer.fee' ? CustomerInvoice::PATH_XML_FILES_FEE : ($result->documentType->code == 'customer.lease' ? CustomerInvoice::PATH_XML_FILES_LEA : ($result->documentType->code == 'customer.invoice' ? CustomerInvoice::PATH_XML_FILES_CI : '')));
                        $path_files = Helper::setDirectory($path_files,$result->company_id) . '/';
                        $file_xml = $path_files . $result->customerInvoiceCfdi->file_xml;
                        if (!empty($file_xml)) {
                            if (\Storage::exists($file_xml) && Helper::validateXmlToArrayCfdi33($file_xml)) {
                                $tmp = Helper::parseXmlToArrayCfdi33Impuestos($file_xml);
                                $iva = $tmp['iva'] * $result->currency_value * $td;
                                $ieps = $tmp['ieps'] * $result->currency_value * $td;
                                $ret_iva = $tmp['ret_iva'] * $result->currency_value * $td;
                                $ret_isr = $tmp['ret_isr'] * $result->currency_value * $td;
                            }
                        }
                        //
                        $element->income->amount_untaxed += $untaxed;
                        $element->income->amount_iva += $iva;
                        $element->income->amount_ieps += $ieps;
                        $element->income->amount_ret_iva += $ret_iva;
                        $element->income->amount_ret_isr += $ret_isr;
                        $element->income->amount_total += $total;
                    }
                }
            }

            if(in_array($customer_remission_include, ['1','2'])){
                $results = CustomerRemission::totalDashboard(
                    ['filter_document_type_code' => ['customer.remission']]
                )
                ->whereMonth('date', '=', $month)
                ->whereYear('date', '=', $year)
                ->doesntHave('customerInvoice')
                ->with('documentType')
                ->get();
                if($results->isNotEmpty()){
                    foreach($results as $result){
                        $td = 1;
                        $untaxed = $result->amount_untaxed * $result->currency_value * $td;
                        $total = $result->amount_total * $result->currency_value * $td;
                        $iva = 0;
                        $ieps = 0;
                        $ret_iva = 0;
                        $ret_isr = 0;
                        //
                        //
                        $element->income->amount_untaxed += $untaxed;
                        $element->income->amount_iva += $iva;
                        $element->income->amount_ieps += $ieps;
                        $element->income->amount_ret_iva += $ret_iva;
                        $element->income->amount_ret_isr += $ret_isr;
                        $element->income->amount_total += $total;
                    }
                }
            }

            $results = CfdiDownload::totalDashboard(
                ['filter_cfdi_type' => ['I','E']]
            )
            ->where('uuid', '<>', '')
            ->whereMonth('date', '=', $month)
            ->whereYear('date', '=', $year)
            ->with('cfdiType')
            ->with('customerInvoiceCfdi')
            ->get();
            if($results->isNotEmpty()){
                foreach($results as $result){
                    $td = $result->cfdiType->code == 'E' ? (-1) : 1;
                    $untaxed = $result->amount_untaxed * $result->currency_value * $td;
                    $total = $result->amount_total * $result->currency_value * $td;
                    $iva = 0;
                    $ieps = 0;
                    $ret_iva = 0;
                    $ret_isr = 0;
                    //
                    $path_files = Helper::setDirectory(CfdiDownload::PATH_FILES,$result->company_id) . '/';
                    $file_xml = $path_files . $result->file_xml;
                    if (!empty($file_xml)) {
                        if (\Storage::exists($file_xml) && Helper::validateXmlToArrayCfdi33($file_xml)) {
                            $tmp = Helper::parseXmlToArrayCfdi33Impuestos($file_xml);
                            $iva = $tmp['iva'] * $result->currency_value * $td;
                            $ieps = $tmp['ieps'] * $result->currency_value * $td;
                            $ret_iva = $tmp['ret_iva'] * $result->currency_value * $td;
                            $ret_isr = $tmp['ret_isr'] * $result->currency_value * $td;
                        }
                    }
                    //
                    if($result->type == '1'){
                        $element->expenses->amount_untaxed += $untaxed;
                        $element->expenses->amount_iva += $iva;
                        $element->expenses->amount_ieps += $ieps;
                        $element->expenses->amount_ret_iva += $ret_iva;
                        $element->expenses->amount_ret_isr += $ret_isr;
                        $element->expenses->amount_total += $total;
                    }else if($result->type == '2' && empty($result->customerInvoiceCfdi)){
                        $element->income->amount_untaxed += $untaxed;
                        $element->income->amount_iva += $iva;
                        $element->income->amount_ieps += $ieps;
                        $element->income->amount_ret_iva += $ret_iva;
                        $element->income->amount_ret_isr += $ret_isr;
                        $element->income->amount_total += $total;
                    }
                }
            }

            //Sumatorias
            $totales->income->amount_untaxed += $element->income->amount_untaxed;
            $totales->income->amount_iva += $element->income->amount_iva;
            $totales->income->amount_ieps += $element->income->amount_ieps;
            $totales->income->amount_ret_iva += $element->income->amount_ret_iva;
            $totales->income->amount_ret_isr += $element->income->amount_ret_isr;
            $totales->income->amount_total += $element->income->amount_total;
            $totales->expenses->amount_untaxed += $element->expenses->amount_untaxed;
            $totales->expenses->amount_iva += $element->expenses->amount_iva;
            $totales->expenses->amount_ieps += $element->expenses->amount_ieps;
            $totales->expenses->amount_ret_iva += $element->expenses->amount_ret_iva;
            $totales->expenses->amount_ret_isr += $element->expenses->amount_ret_isr;
            $totales->expenses->amount_total += $element->expenses->amount_total;

            //
            $data[] = (object)[
                'month' => $text_months[$month] ?? '',
                'income_amount_untaxed' => $format ? Helper::numberFormatMoney($element->income->amount_untaxed, 2) : Helper::numberFormat($element->income->amount_untaxed, 2, false),
                'income_amount_iva' => $format ? Helper::numberFormatMoney($element->income->amount_iva, 2) : Helper::numberFormat($element->income->amount_iva, 2, false),
                'income_amount_ieps' => $format ? Helper::numberFormatMoney($element->income->amount_ieps, 2) : Helper::numberFormat($element->income->amount_ieps, 2, false),
                'income_amount_ret_iva' => $format ? Helper::numberFormatMoney($element->income->amount_ret_iva, 2) : Helper::numberFormat($element->income->amount_ret_iva, 2, false),
                'income_amount_ret_isr' => $format ? Helper::numberFormatMoney($element->income->amount_ret_isr, 2) : Helper::numberFormat($element->income->amount_ret_isr, 2, false),
                'income_amount_total' => $format ? Helper::numberFormatMoney($element->income->amount_total, 2) : Helper::numberFormat($element->income->amount_total, 2, false),
                'expenses_amount_untaxed' => $format ? Helper::numberFormatMoney($element->expenses->amount_untaxed, 2) : Helper::numberFormat($element->expenses->amount_untaxed, 2, false),
                'expenses_amount_iva' => $format ? Helper::numberFormatMoney($element->expenses->amount_iva, 2) : Helper::numberFormat($element->expenses->amount_iva, 2, false),
                'expenses_amount_ieps' => $format ? Helper::numberFormatMoney($element->expenses->amount_ieps, 2) : Helper::numberFormat($element->expenses->amount_ieps, 2, false),
                'expenses_amount_ret_iva' => $format ? Helper::numberFormatMoney($element->expenses->amount_ret_iva, 2) : Helper::numberFormat($element->expenses->amount_ret_iva, 2, false),
                'expenses_amount_ret_isr' => $format ? Helper::numberFormatMoney($element->expenses->amount_ret_isr, 2) : Helper::numberFormat($element->expenses->amount_ret_isr, 2, false),
                'expenses_amount_total' => $format ? Helper::numberFormatMoney($element->expenses->amount_total, 2) : Helper::numberFormat($element->expenses->amount_total, 2, false),
                'style' => ''
            ];
        }

        $data[] = (object)[
            'month' => __('general.text_total'),
            'income_amount_untaxed' => $format ? Helper::numberFormatMoney($totales->income->amount_untaxed, 2) : Helper::numberFormat($totales->income->amount_untaxed, 2, false),
            'income_amount_iva' => $format ? Helper::numberFormatMoney($totales->income->amount_iva, 2) : Helper::numberFormat($totales->income->amount_iva, 2, false),
            'income_amount_ieps' => $format ? Helper::numberFormatMoney($totales->income->amount_ieps, 2) : Helper::numberFormat($totales->income->amount_ieps, 2, false),
            'income_amount_ret_iva' => $format ? Helper::numberFormatMoney($totales->income->amount_ret_iva, 2) : Helper::numberFormat($totales->income->amount_ret_iva, 2, false),
            'income_amount_ret_isr' => $format ? Helper::numberFormatMoney($totales->income->amount_ret_isr, 2) : Helper::numberFormat($totales->income->amount_ret_isr, 2, false),
            'income_amount_total' => $format ? Helper::numberFormatMoney($totales->income->amount_total, 2) : Helper::numberFormat($totales->income->amount_total, 2, false),
            'expenses_amount_untaxed' => $format ? Helper::numberFormatMoney($totales->expenses->amount_untaxed, 2) : Helper::numberFormat($totales->expenses->amount_untaxed, 2, false),
            'expenses_amount_iva' => $format ? Helper::numberFormatMoney($totales->expenses->amount_iva, 2) : Helper::numberFormat($totales->expenses->amount_iva, 2, false),
            'expenses_amount_ieps' => $format ? Helper::numberFormatMoney($totales->expenses->amount_ieps, 2) : Helper::numberFormat($totales->expenses->amount_ieps, 2, false),
            'expenses_amount_ret_iva' => $format ? Helper::numberFormatMoney($totales->expenses->amount_ret_iva, 2) : Helper::numberFormat($totales->expenses->amount_ret_iva, 2, false),
            'expenses_amount_ret_isr' => $format ? Helper::numberFormatMoney($totales->expenses->amount_ret_isr, 2) : Helper::numberFormat($totales->expenses->amount_ret_isr, 2, false),
            'expenses_amount_total' => $format ? Helper::numberFormatMoney($totales->expenses->amount_total, 2) : Helper::numberFormat($totales->expenses->amount_total, 2, false),
            'style' => 'total'
        ];

        return $data;
    }
}
