<?php

namespace App\Http\Controllers\Shop;

use App\Models\Shop\ShopProduct;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class ShopController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //Variables
        $limit = ($request->has('limit') ? $request->get('limit') : 100);

        //Consulta
        $results = ShopProduct::filter($request->all())->shopAll()->paginate($limit);

        //Se agregaron solo dos formas de pago configuradas manualmente
        //01 - Efectivo
        //03 - Transferencia electrónica de fondos

        //Vista
        return view('shop.shop.index', compact('results'));
    }
}
