<?php

namespace App\Http\Middleware;

use Auth;
use Closure;

class LogoutUsers
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if(Auth::check()){
            $user = Auth::user();
            $logout = false;

            if(empty($user->status)){
                $logout = true;
            }

            if($user->superadmin == 0 && $user->distributor == 0 && !empty($user->sys_customer_id)){
                if($user->sysCustomer->status == 0){
                    $logout = true;
                }
            }

            if($logout){
                auth()->logout();
                return redirect('/');
            }
        }

        return $next($request);

    }
}
