<?php

namespace App\Imports;

use App\Helpers\Helper;
use App\Models\Catalogs\Tax;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class CustomerInvoiceTemplateBeforeImportImport implements ToCollection, WithHeadingRow
{
    /**
     * @param Collection $rows
     * @return bool
     * @throws \Exception
     */
    public function collection(Collection $rows)
    {
        //Limpieza de datos
        $rows = Helper::clearArrayImport($rows);

        //Importar datos
        $this->total_customer_invoices = 0;
        $this->total_amount_customer_invoices = 0;

        //Agrupamos los datos correctamente
        $data_customer_invoices = [];
        $count=0;
        foreach ($rows as $row) {
            //Valida impuestos
            $tax = null;
            $taxes = [];
            $taxesArr = [];
            if (!empty($row['impuestos'])) {
                $taxesArr = explode(', ', $row['impuestos']);
                for($i = 0; $i < count($taxesArr); $i++){
                    $tax = Tax::where('name', '=', $taxesArr[$i])->first();
                    if(!empty($tax)){
                        array_push($taxes, $tax->id);
                    }
                }
            }
            //Encabezado
            if (!empty($row['rfc_cliente']) && !empty($row['cliente']) && !empty($row['sucursal'])) {
                $data_customer_invoices[$count] = [
                    'taxid' => $row['rfc_cliente'],
                    'customer' => $row['cliente'],
                    'branch_office_id' => $row['sucursal'],
                    'currency_id' => $row['moneda'],
                    'payment_term_id' => $row['terminos_de_pago'],
                    'date_due' => $row['fecha_de_vencimiento'],
                    'salesperson_id' => $row['vendedor'],
                    'payment_way_id' => $row['forma_de_pago'],
                    'payment_method_id' => $row['metodo_de_pago'],
                    'cfdi_use_id' => $row['uso_de_cfdi'],
                    'cfdi_relation_id' => $row['tipo_de_relacion'],
                    'uuids' => $row['uuids'],
                ];
                if(!empty($row['descripcion']) && !empty($row['precio'])) {
                    $data_customer_invoices[$count]['item'][] = [
                        'quantity' => $row['cantidad'],
                        'product_id' => $row['producto'],
                        'name' => $row['descripcion'],
                        'unit_measure_id' => $row['u_m'],
                        'sat_product_id' => $row['prodserv_sat'],
                        'price_unit' => $row['precio'],
                        'includes_iva' => $row['iva_incluido'] == 'S' ? 1 : 0,
                        'taxes' => $taxes,
                        'discount' => 0,
                    ];
                }
                $count++;
            }elseif(!empty($row['descripcion']) && !empty($row['precio'])){
                $data_customer_invoices[$count-1]['item'][] = [
                    'quantity' => $row['cantidad'],
                    'product_id' => $row['producto'],
                    'name' => $row['descripcion'],
                    'unit_measure_id' => $row['u_m'],
                    'sat_product_id' => $row['prodserv_sat'],
                    'price_unit' => $row['precio'],
                    'includes_iva' => $row['iva_incluido'] == 'S' ? 1 : 0,
                    'taxes' => $taxes,
                    'discount' => 0,
                ];
            }
        }

        $this->total_customer_invoices = $count;
        if(!empty($data_customer_invoices)){
            foreach($data_customer_invoices as $request){
                $request = (object) $request;

                //Guardar
                //Registro principal

                //Registro de lineas
                $amount_discount = 0;
                $amount_untaxed = 0;
                $amount_tax = 0;
                $amount_tax_ret = 0;
                $amount_total = 0;
                $balance = 0;
                //Lineas
                if (!empty($request->item)) {
                    foreach ($request->item as $key => $item) {
                        //Logica
                        $item_quantity = (double)$item['quantity'];
                        $item_price_unit = (double)$item['price_unit'];
                        //Ajuste para cuando tiene IVA incluido
                        if (!empty($item['taxes']) && !empty($item['includes_iva'])) {
                            foreach ($item['taxes'] as $tax_id) {
                                if (!empty($tax_id)) {
                                    $tax = Tax::findOrFail($tax_id);
                                    if($tax->code == '002' && $tax->rate>0) {
                                        if ($tax->factor == 'Tasa') {
                                            $item_price_unit = $item_price_unit / (1+($tax->rate/100));
                                        } elseif ($tax->factor == 'Cuota') {
                                            $item_price_unit -= $tax->rate;
                                        }
                                        $item_price_unit = round($item_price_unit, \App\Helpers\Helper::companyProductPriceDecimalPlace());
                                        $request->item[$key]['price_unit'] = $item_price_unit;
                                    }
                                }
                                break;
                            }
                        }
                        $item_discount = (double)$item['discount'];
                        $item_price_reduce = ($item_price_unit * (100 - $item_discount) / 100);
                        $item_amount_untaxed = round($item_quantity * $item_price_reduce, 2);
                        $item_amount_discount = round($item_quantity * $item_price_unit, 2) - $item_amount_untaxed;
                        $item_amount_tax = 0;
                        $item_amount_tax_ret = 0;
                        if (!empty($item['taxes'])) {
                            foreach ($item['taxes'] as $tax_id) {
                                if (!empty($tax_id)) {
                                    $tax = Tax::findOrFail($tax_id);
                                    $tmp = 0;
                                    if ($tax->factor == 'Tasa') {
                                        $tmp = $item_amount_untaxed * $tax->rate / 100;
                                    } elseif ($tax->factor == 'Cuota') {
                                        $tmp = $tax->rate;
                                    }
                                    $tmp = round($tmp, 2);
                                    if ($tax->type == 'R') { //Retenciones
                                        $item_amount_tax_ret += $tmp;
                                    } else { //Traslados
                                        $item_amount_tax += $tmp;
                                    }

                                    //Sumatoria de impuestos
                                    $taxes[$tax_id] = array(
                                        'amount_base' => $item_amount_untaxed + (isset($taxes[$tax_id]['amount_base']) ? $taxes[$tax_id]['amount_base'] : 0),
                                        'amount_tax' => $tmp + (isset($taxes[$tax_id]['amount_tax']) ? $taxes[$tax_id]['amount_tax'] : 0),
                                    );
                                }
                            }
                        }
                        $item_amount_total = $item_amount_untaxed + $item_amount_tax + $item_amount_tax_ret;
                        //Sumatoria totales
                        $amount_discount += $item_amount_discount;
                        $amount_untaxed += $item_amount_untaxed;
                        $amount_tax += $item_amount_tax;
                        $amount_tax_ret += $item_amount_tax_ret;
                        $amount_total += $item_amount_total;
                    }
                }
                //Acumula totales
                $this->total_amount_customer_invoices += $amount_total;
            }
        }
    }
}
