<?php

namespace App\Imports;

use App\Helpers\Helper;
use App\Models\Catalogs\Tax;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class CustomerPaymentTemplateBeforeImportImport implements ToCollection, WithHeadingRow
{
    /**
     * @param Collection $rows
     * @return bool
     * @throws \Exception
     */
    public function collection(Collection $rows)
    {
        //Limpieza de datos
        $rows = Helper::clearArrayImport($rows);

        //Importar datos
        $this->total_customer_payments = 0;
        $this->total_amount_customer_payments = 0;

        //Agrupamos los datos correctamente
        $data_customer_payments = [];
        $count=0;
        foreach ($rows as $row) {
            //Valida impuestos
            //Encabezado
            if (!empty($row['rfc_cliente']) && !empty($row['cliente']) && !empty($row['sucursal'])) {
                $data_customer_payments[$count] = [
                    'taxid' => $row['rfc_cliente'],
                    'customer' => $row['cliente'],
                    'branch_office_id' => $row['sucursal'],
                    'currency_id' => $row['moneda'],
                    'date_payment' => $row['fecha_de_pago'],
                    'payment_way_id' => $row['forma_de_pago'],
                    'amount' => $row['monto'],
                    'cfdi_relation_id' => $row['tipo_de_relacion'],
                    'uuids' => $row['uuids'],
                ];
                if(!empty($row['factura']) && !empty($row['importe_pagado'])) {
                    $data_customer_payments[$count]['item'][] = [
                        'reconciled_name' => $row['factura'],
                        'currency_value' => $row['tc_de_pago'],
                        'amount_reconciled' => $row['importe_pagado'],
                    ];
                }
                $count++;
            }elseif(!empty($row['factura']) && !empty($row['importe_pagado'])){
                $data_customer_payments[$count-1]['item'][] = [
                    'reconciled_name' => $row['factura'],
                    'currency_value' => $row['tc_de_pago'],
                    'amount_reconciled' => $row['importe_pagado'],
                ];
            }
        }

        $this->total_customer_payments = $count;
        if(!empty($data_customer_payments)){
            foreach($data_customer_payments as $request){
                $request = (object) $request;

                //Guardar
                //Registro principal

                //Registro de lineas
                $amount_total = $request->amount;
                $balance = 0;

                //Acumula totales
                $this->total_amount_customer_payments += $amount_total;
            }
        }
    }
}
