<?php

namespace App\Imports;

use App\Helpers\Helper;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class CustomerTemplateBeforeImportImport implements ToCollection, WithHeadingRow
{

    /**
     * @param Collection $rows
     * @return mixed
     * @throws \Exception
     */
    public function collection(Collection $rows)
    {
        //Limpieza de datos
        $rows = Helper::clearArrayImport($rows);

        //Importar datos
        $this->total_customers = 0;
        foreach ($rows as $row) {
            if (!empty($row['nombre']) && !empty($row['rfc'])) {
                $this->total_customers++;
            }
        }
    }
}
