<?php

namespace App\Imports;

use App\Helpers\Helper;
use App\Models\Auth\User;
use App\Models\Catalogs\CfdiUse;
use App\Models\Catalogs\City;
use App\Models\Catalogs\Country;
use App\Models\Catalogs\PaymentMethod;
use App\Models\Catalogs\PaymentTerm;
use App\Models\Catalogs\PaymentWay;
use App\Models\Catalogs\State;
use App\Models\Catalogs\TaxRegimen;
use App\Models\Sales\Customer;
use App\Models\Sales\Salesperson;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class CustomerTemplateImportImport implements ToCollection, WithHeadingRow
{

    /**
     * @param Collection $rows
     * @return mixed
     * @throws \Exception
     */
    public function collection(Collection $rows)
    {
        //Limpieza de datos
        $rows = Helper::clearArrayImport($rows);

        //Validacion
        foreach ($rows as $key => $row) {
            $num_row = $key + 2;
            $rows[$key]['nombre'] = trim(str_replace('  ', ' ', $row['nombre']));
            $rows[$key]['rfc'] = $row['rfc'] = strtoupper(trim($row['rfc']));

            Validator::make($row->toArray(), [
                'nombre' => 'required',
                'rfc' => [
                    'required',
                    'regex:/^[A-Z&Ñ]{3,4}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A]$/i'
                ],
                'terminos_de_pago' => 'required',
                'pais' => 'required',
            ], [
                'nombre.*' => __('sales/customer.error_name') . sprintf(__('sales/customer.error_row'), $num_row,$row['nombre']),
                'rfc.required' => __('sales/customer.error_taxid') . sprintf(__('sales/customer.error_row'), $num_row,$row['rfc']),
                'rfc.regex' => __('sales/customer.error_taxid_format') . sprintf(__('sales/customer.error_row'), $num_row,$row['rfc']),
                'terminos_de_pago.*' => __('sales/customer.error_payment_term_id') . sprintf(__('sales/customer.error_row'), $num_row,$row['terminos_de_pago']),
                'pais.*' => __('sales/customer.error_country_id') . sprintf(__('sales/customer_invoice.error_row'), $num_row,$row['pais']),
            ])->validate();
        }

        $company = Helper::firstCompany(); //Empresa
        if(!empty(setting('customers_per_taxid'))){
            $company = Helper::defaultCompany(); //Empresa
        }

        //Importar datos
        foreach ($rows as $key => $row) {
            $num_row = $key + 2;

            //Validamos que RFC no ste registrado previamente
            $row['rfc'] = strtoupper(trim($row['rfc']));
            if (!empty($row['rfc']) && $row['rfc'] != 'XAXX010101000' && $row['rfc'] != 'XEXX010101000') {
                $customer_taxid = Customer::where('taxid', '=', $row['rfc'])->where('company_id', '=', $company->id)->first();
                if (!empty($customer_taxid)) {
                    //throw new \Exception(__('sales/customer.error_taxid_unique') . sprintf(__('sales/customer.error_row'), $num_row,$row['rfc']));
                    //flash(sprintf(__('sales/customer.error_import_already_registered'),$row['nombre'],$row['rfc']))->warning();
                    //continue;
                }
            }

            //Régimen fiscal
            $tax_regimen = null;
            if (!empty($row['regimen_fiscal'])) {
                $tax_regimen = TaxRegimen::where('name', '=', $row['regimen_fiscal'])->first();
                if (empty($tax_regimen)) {
                    throw new \Exception(__('sales/customer.error_tax_regimen_id2') . sprintf(__('sales/customer.error_row'), $num_row,$row['regimen_fiscal']));
                }
            }
            //Termino de pago
            $payment_term = null;
            if (!empty($row['terminos_de_pago'])) {
                $payment_term = PaymentTerm::where('name', '=', $row['terminos_de_pago'])->first();
                if (empty($payment_term)) {
                    throw new \Exception(__('sales/customer.error_payment_term_id2') . sprintf(__('sales/customer.error_row'), $num_row,$row['terminos_de_pago']));
                }
            }else{
                throw new \Exception(__('sales/customer.error_payment_term_id') . sprintf(__('sales/customer.error_row'), $num_row,$row['terminos_de_pago']));
            }
            //Forma de pago
            $payment_way = null;
            if (!empty($row['forma_de_pago'])) {
                $payment_way = PaymentWay::where('name', '=', $row['forma_de_pago'])->first();
                if (empty($payment_way)) {
                    throw new \Exception(__('sales/customer.error_payment_way_id2') . sprintf(__('sales/customer.error_row'), $num_row,$row['forma_de_pago']));
                }
            }
            //Metodo de pago
            $payment_method = null;
            if (!empty($row['metodo_de_pago'])) {
                $payment_method = PaymentMethod::where('code', '=', $row['metodo_de_pago'])->first();
                if (empty($payment_method)) {
                    throw new \Exception(__('sales/customer.error_payment_method_id2') . sprintf(__('sales/customer.error_row'), $num_row,$row['metodo_de_pago']));
                }
            }
            //Uso de CFDI
            $cfdi_use = null;
            if (!empty($row['uso_de_cfdi'])) {
                $cfdi_use = CfdiUse::where('name', '=', $row['uso_de_cfdi'])->first();
                if (empty($cfdi_use)) {
                    throw new \Exception(__('sales/customer.error_cfdi_use_id2') . sprintf(__('sales/customer.error_row'), $num_row,$row['uso_de_cfdi']));
                }
            }
            //Vendedor
            $salesperson = null;
            if (!empty($row['vendedor'])) {
                $salesperson = Salesperson::where('name', '=', $row['vendedor'])->first();
                if (empty($salesperson)) {
                    throw new \Exception(__('sales/customer.error_salesperson_id2') . sprintf(__('sales/customer_invoice.error_row'), $num_row,$row['vendedor']));
                }
            }
            //Pais
            $country = null;
            if (!empty($row['pais'])) {
                $country = Country::where('name', '=', $row['pais'])->first();
                if (empty($country)) {
                    throw new \Exception(__('sales/customer.error_country_id2') . sprintf(__('sales/customer.error_row'), $num_row,$row['pais']));
                }
            }else{
                throw new \Exception(__('sales/customer.error_country_id') . sprintf(__('sales/customer.error_row'), $num_row,$row['pais']));
            }
            //Estado
            $state = null;
            if (!empty($row['estado'])) {
                $state = State::where('name', '=', $row['estado'])->first();
                if (empty($state)) {
                    throw new \Exception(__('sales/customer.error_state_id2') . sprintf(__('sales/customer.error_row'), $num_row,$row['estado']));
                }
            }
            //Municipio
            $city = null;
            if (!empty($row['municipio'])) {
                $city = City::where('name', '=', $row['municipio'])->first();
                if (empty($city)) {
                    throw new \Exception(__('sales/customer.error_city_id2') . sprintf(__('sales/customer.error_row'), $num_row,$row['municipio']));
                }
            }

            //Guardar
            if(in_array($row['rfc'], ['XAXX010101000','XEXX010101000'])){
                $customer = Customer::where('taxid',$row['rfc'])->where('name',$row['nombre'])->where('company_id', $company->id)->first();
            }else{
                $customer = Customer::where('taxid',$row['rfc'])->where('company_id', $company->id)->first();
            }
            if(!empty($customer)){
                $customer->updated_uid = \Auth::user()->id;
                $customer->name = $row['nombre'];
                $customer->taxid = $row['rfc'];
                $customer->email = $row['correo_electronico'];
                $customer->phone = $row['telefono'];
                $customer->tax_regimen_id = $tax_regimen->id ?? null;
                $customer->payment_term_id = $payment_term->id ?? null;
                $customer->payment_way_id = $payment_way->id ?? null;
                $customer->payment_method_id = $payment_method->id ?? null;
                $customer->cfdi_use_id = $cfdi_use->id ?? null;
                $customer->salesperson_id = $salesperson->id ?? null;
                $customer->address_1 = $row['direccion'];
                $customer->address_2 = $row['num_ext'];
                $customer->address_3 = $row['num_int'];
                $customer->address_4 = $row['colonia'];
                $customer->city_id = $city->id ?? null;
                $customer->state_id = $state->id ?? null;
                $customer->country_id = $country->id ?? null;
                $customer->postcode = $row['cp'];
                $customer->save();
            }else{
                $customer = Customer::create([
                    'created_uid' => \Auth::user()->id,
                    'updated_uid' => \Auth::user()->id,
                    'name' => $row['nombre'],
                    'taxid' => $row['rfc'],
                    'email' => $row['correo_electronico'],
                    'phone' => $row['telefono'],
                    'tax_regimen_id' => $tax_regimen->id ?? null,
                    'payment_term_id' => $payment_term->id ?? null,
                    'payment_way_id' => $payment_way->id ?? null,
                    'payment_method_id' => $payment_method->id ?? null,
                    'cfdi_use_id' => $cfdi_use->id ?? null,
                    'salesperson_id' => $salesperson->id ?? null,
                    'address_1' => $row['direccion'],
                    'address_2' => $row['num_ext'],
                    'address_3' => $row['num_int'],
                    'address_4' => $row['colonia'],
                    'city_id' => $city->id ?? null,
                    'state_id' => $state->id ?? null,
                    'country_id' => $country->id ?? null,
                    'postcode' => $row['cp'],
                    'status' => 1,
                    'company_id' => $company->id
                ]);
            }
        }

        return true;
    }
}
