<?php

namespace App\Imports;

use App\Helpers\Helper;
use App\Models\Auth\User;
use App\Models\Base\Employee;
use App\Models\Catalogs\Bank;
use App\Models\Catalogs\State;
use App\Models\Catalogs\Country;
use Illuminate\Support\Collection;
use App\Models\Catalogs\TaxRegimen;
use App\Models\Catalogs\WorkdayType;
use App\Models\Base\EmployeeCategory;
use App\Models\Catalogs\ContractType;
use App\Models\Catalogs\JobRiskClasse;
use App\Models\Catalogs\FrequencyPayment;
use Illuminate\Support\Facades\Validator;
use App\Models\Catalogs\RecruitmentRegime;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class EmployeeTemplateImportImport implements ToCollection, WithHeadingRow
{

    /**
     * @param Collection $rows
     * @return mixed
     * @throws \Exception
     */
    public function collection(Collection $rows)
    {
        //Limpieza de datos
        $rows = Helper::clearArrayImport($rows);

        //Validacion
        foreach ($rows as $key => $row) {
            $num_row = $key + 2;
            $rows[$key]['rfc'] = $row['rfc'] = strtoupper(trim($row['rfc']));
            $rows[$key]['curp'] = $row['curp'] = strtoupper(trim($row['curp']));

            if(!empty($row['fecha_de_inicio_de_relacion_laboral'])){
                if (strpos($row['fecha_de_inicio_de_relacion_laboral'], "'") || strpos($row['fecha_de_inicio_de_relacion_laboral'], "-") || strpos($row['fecha_de_inicio_de_relacion_laboral'], "/")) {
                    $rows[$key]['fecha_de_inicio_de_relacion_laboral'] = $row['fecha_de_inicio_de_relacion_laboral'] = str_replace('\'', '', str_replace('/', '-', $row['fecha_de_inicio_de_relacion_laboral']));
                } else {
                    $rows[$key]['fecha_de_inicio_de_relacion_laboral'] = \Date::instance(\PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['fecha_de_inicio_de_relacion_laboral']))->format(setting('date_format', 'd-m-Y'));
                }
            }

            Validator::make($row->toArray(), [
                'numero_de_empleado' => 'required',
                'nombres' => 'required',
                'apellido_paterno' => 'required',
                'rfc' => [
                    'required',
                    'regex:/^[A-Z&Ñ]{3,4}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A]$/i'
                ],
                'curp' => 'required|size:18',
                /*'nss' => 'required',*/
                'correo_electronico' => 'nullable|email',
                'regimen_de_contratacion' => 'required',
                'fecha_de_inicio_de_relacion_laboral' => 'nullable|date|date_format:"'.setting('date_format', 'd-m-Y').'"',
                'esta_sindicalizado' => 'required|in:SI,NO',
                /*'tipo_de_jornada' => 'required',*/
                'tipo_de_contrato' => 'required',
                'periodicidad_de_pago' => 'required',
                'salario_base_cotizacion' => 'nullable|numeric|min:0',
                'salario_diario_integrado' => 'nullable|numeric|min:0',
                'pais' => 'required',
                'entidad_donde_presto_el_servicio' => 'required',
            ], [
                'numero_de_empleado.*' => __('base/employee.error_code') . sprintf(__('base/employee.error_row'), $num_row,$row['numero_de_empleado']),
                'nombres.*' => __('base/employee.error_firstname') . sprintf(__('base/employee.error_row'), $num_row,$row['nombres']),
                'apellido_paterno.*' => __('base/employee.error_lastname') . sprintf(__('base/employee.error_row'), $num_row,$row['apellido_paterno']),
                'rfc.required' => __('base/employee.error_taxid') . sprintf(__('base/employee.error_row'), $num_row,$row['rfc']),
                'rfc.regex' => __('base/employee.error_taxid_format') . sprintf(__('base/employee.error_row'), $num_row,$row['rfc']),
                'curp.*' => __('base/employee.error_curp') . sprintf(__('base/employee.error_row'), $num_row,$row['curp']),
                /*'nss.*' => __('base/employee.error_nss') . sprintf(__('base/employee.error_row'), $num_row,$row['nss']),*/
                'correo_electronico.*' => __('base/employee.error_email_format') . sprintf(__('base/employee.error_row'), $num_row,$row['correo_electronico']),
                'regimen_de_contratacion.*' => __('base/employee.error_recruitment_regime_id') . sprintf(__('base/employee.error_row'), $num_row,$row['regimen_de_contratacion']),
                'fecha_de_inicio_de_relacion_laboral.required' => __('base/employee.error_date_start_work') . sprintf(__('base/employee.error_row'), $num_row,$row['fecha_de_inicio_de_relacion_laboral']),
                'fecha_de_inicio_de_relacion_laboral.date' => __('base/employee.error_date_start_work_format') . sprintf(__('base/employee.error_row'), $num_row,$row['fecha_de_inicio_de_relacion_laboral']),
                'fecha_de_inicio_de_relacion_laboral.date_format' => __('base/employee.error_date_start_work_format') . sprintf(__('base/employee.error_row'), $num_row,$row['fecha_de_inicio_de_relacion_laboral']),
                'esta_sindicalizado.*' => __('base/employee.error_unionized2') . sprintf(__('base/employee.error_row'), $num_row,$row['esta_sindicalizado']),
                /*'tipo_de_jornada.*' => __('base/employee.error_workday_type_id') . sprintf(__('base/employee.error_row'), $num_row,$row['tipo_de_jornada']),*/
                'tipo_de_contrato.*' => __('base/employee.error_contract_type_id') . sprintf(__('base/employee.error_row'), $num_row,$row['tipo_de_contrato']),
                'periodicidad_de_pago.*' => __('base/employee.error_frequency_payment_id') . sprintf(__('base/employee.error_row'), $num_row,$row['periodicidad_de_pago']),
                'salario_base_cotizacion.*' => __('base/employee.error_base_salary') . sprintf(__('base/employee.error_row'), $num_row,$row['salario_base_cotizacion']),
                'salario_diario_integrado.*' => __('base/employee.error_sdi') . sprintf(__('base/employee.error_row'), $num_row,$row['salario_diario_integrado']),
                'pais.*' => __('base/employee.error_country_id') . sprintf(__('base/employee.error_row'), $num_row,$row['pais']),
                'entidad_donde_presto_el_servicio.*' => __('base/employee.error_state_id') . sprintf(__('base/employee.error_row'), $num_row,$row['entidad_donde_presto_el_servicio']),
            ])->validate();
        }

        $company = Helper::defaultCompany(); //Empresa

        //Importar datos
        foreach ($rows as $key => $row) {
            $num_row = $key + 2;

            //Validamos que RFC no ste registrado previamente
            $row['rfc'] = strtoupper(trim($row['rfc']));
            if (!empty($row['rfc']) && $row['rfc'] != 'XAXX010101000' && $row['rfc'] != 'XEXX010101000') {
                $employee_taxid = Employee::where('taxid', '=', $row['rfc'])->where('company_id', '=', $company->id)->first();
                if (!empty($employee_taxid)) {
                    //throw new \Exception(__('base/employee.error_taxid_unique') . sprintf(__('base/employee.error_row'), $num_row,$row['rfc']));
                }
            }

            //Régimen fiscal
            $tax_regimen = null;
            if (!empty($row['regimen_fiscal'])) {
                $tax_regimen = TaxRegimen::where('name', '=', $row['regimen_fiscal'])->first();
                if (empty($tax_regimen)) {
                    throw new \Exception(__('base/employee.error_tax_regimen_id2') . sprintf(__('base/employee.error_row'), $num_row,$row['regimen_fiscal']));
                }
            }
            //Regimen de contratacion
            $recruitment_regime = null;
            if (!empty($row['regimen_de_contratacion'])) {
                $recruitment_regime = RecruitmentRegime::where('name', '=', $row['regimen_de_contratacion'])->first();
                if (empty($recruitment_regime)) {
                    throw new \Exception(__('base/employee.error_recruitment_regime_id2') . sprintf(__('base/employee.error_row'), $num_row,$row['regimen_de_contratacion']));
                }
            }
            //Tipo de jornada
            $workday_type = null;
            if (!empty($row['tipo_de_jornada'])) {
                $workday_type = WorkdayType::where('name', '=', $row['tipo_de_jornada'])->first();
                if (empty($workday_type)) {
                    throw new \Exception(__('base/employee.error_workday_type_id2') . sprintf(__('base/employee.error_row'), $num_row,$row['tipo_de_jornada']));
                }
            }
            //Categoria
            $employee_category = null;
            if (!empty($row['categoria'])) {
                $employee_category = EmployeeCategory::where('name', '=', $row['categoria'])->first();
                if (empty($employee_category)) {
                    throw new \Exception(__('base/employee.error_employee_category_id2') . sprintf(__('base/employee.error_row'), $num_row,$row['categoria']));
                }
            }
            //Tipo de contrato
            $contract_type = null;
            if (!empty($row['tipo_de_contrato'])) {
                $contract_type = ContractType::where('name', '=', $row['tipo_de_contrato'])->first();
                if (empty($contract_type)) {
                    throw new \Exception(__('base/employee.error_contract_type_id2') . sprintf(__('base/employee.error_row'), $num_row,$row['tipo_de_contrato']));
                }
            }
            //Riesgo de trabajo
            $job_risk_classe = null;
            if (!empty($row['riesgo_puesto'])) {
                $job_risk_classe = JobRiskClasse::where('name', '=', $row['riesgo_puesto'])->first();
                if (empty($job_risk_classe)) {
                    throw new \Exception(__('base/employee.error_job_risk_classe_id2') . sprintf(__('base/employee.error_row'), $num_row,$row['riesgo_puesto']));
                }
            }
            //Frecuencia de pago
            $frequency_payment = null;
            if (!empty($row['periodicidad_de_pago'])) {
                $frequency_payment = FrequencyPayment::where('name', '=', $row['periodicidad_de_pago'])->first();
                if (empty($frequency_payment)) {
                    throw new \Exception(__('base/employee.error_frequency_payment_id2') . sprintf(__('base/employee.error_row'), $num_row,$row['periodicidad_de_pago']));
                }
            }
            //Banco
            $bank = null;
            if (!empty($row['banco'])) {
                $bank = Bank::where('name', '=', $row['banco'])->first();
                if (empty($bank)) {
                    throw new \Exception(__('base/employee.error_bank_id2') . sprintf(__('base/employee.error_row'), $num_row,$row['banco']));
                }
            }
            //Pais
            $country = null;
            if (!empty($row['pais'])) {
                $country = Country::where('name', '=', $row['pais'])->first();
                if (empty($country)) {
                    throw new \Exception(__('base/employee.error_country_id2') . sprintf(__('base/employee.error_row'), $num_row,$row['pais']));
                }
            }
            //Estado
            $state = null;
            if (!empty($row['entidad_donde_presto_el_servicio'])) {
                $state = State::where('name', '=', $row['entidad_donde_presto_el_servicio'])->first();
                if (empty($state)) {
                    throw new \Exception(__('base/employee.error_state_id2') . sprintf(__('base/employee.error_row'), $num_row,$row['entidad_donde_presto_el_servicio']));
                }
            }

            //Guardar
            if(in_array($row['rfc'], ['XAXX010101000','XEXX010101000'])){
                $employee = Employee::where('taxid',$row['rfc'])->where('firstname',strtoupper(trim($row['nombres'])))->where('company_id', $company->id)->first();
            }else{
                $employee = Employee::where('taxid',$row['rfc'])->where('company_id', $company->id)->first();
            }
            if(!empty($employee)){
                $employee->updated_uid = \Auth::user()->id;
                $employee->name = strtoupper(trim($row['nombres'] . ' ' . trim($row['apellido_paterno']) . ' ' . trim($row['apellido_materno'])));
                $employee->firstname = strtoupper(trim($row['nombres']));
                $employee->lastname = strtoupper(trim($row['apellido_paterno']));
                $employee->lastname2 = strtoupper(trim($row['apellido_materno']));
                $employee->code = $row['numero_de_empleado'];
                $employee->taxid = strtoupper(trim($row['rfc']));
                $employee->curp = strtoupper(trim($row['curp']));
                $employee->nss = $row['nss'];
                $employee->email = $row['correo_electronico'];
                $employee->recruitment_regime_id = $recruitment_regime->id ?? null;
                $employee->date_start_work = !empty($row['fecha_de_inicio_de_relacion_laboral']) ? Helper::convertDateToSql($row['fecha_de_inicio_de_relacion_laboral']) : null;
                $employee->unionized = $row['esta_sindicalizado'] == 'SI' ? 1 : 0;
                $employee->workday_type_id = $workday_type->id ?? null;
                $employee->contract_type_id = $contract_type->id ?? null;
                $employee->department = $row['departamento'];
                $employee->job = $row['puesto'];
                $employee->job_risk_classe_id = $job_risk_classe->id ?? null;
                $employee->frequency_payment_id = $frequency_payment->id ?? null;
                $employee->bank_id = $bank->id ?? null;
                $employee->bank_account = $row['cuenta_bancaria'];
                $employee->base_salary = (double)$row['salario_base_cotizacion'];
                $employee->sdi = (double)$row['salario_diario_integrado'];
                $employee->state_id = $state->id ?? null;
                $employee->country_id = $country->id ?? null;
                $employee->employee_category_id = $employee_category->id ?? null;
                $employee->tax_regimen_id = $tax_regimen->id ?? null;
                $employee->postcode = $row['cp'];
                $employee->save();
            }else{
                //---Registro principal
                $employee = Employee::create([
                    'created_uid' => \Auth::user()->id,
                    'updated_uid' => \Auth::user()->id,
                    'name' => strtoupper(trim($row['nombres'] . ' ' . trim($row['apellido_paterno']) . ' ' . trim($row['apellido_materno']))),
                    'firstname' => strtoupper(trim($row['nombres'])),
                    'lastname' => strtoupper(trim($row['apellido_paterno'])),
                    'lastname2' => strtoupper(trim($row['apellido_materno'])),
                    'code' => $row['numero_de_empleado'],
                    'taxid' => strtoupper(trim($row['rfc'])),
                    'curp' => strtoupper(trim($row['curp'])),
                    'nss' => $row['nss'],
                    'email' => $row['correo_electronico'],
                    'recruitment_regime_id' => $recruitment_regime->id ?? null,
                    'date_start_work' => !empty($row['fecha_de_inicio_de_relacion_laboral']) ? Helper::convertDateToSql($row['fecha_de_inicio_de_relacion_laboral']) : null,
                    'unionized' => $row['esta_sindicalizado'] == 'SI' ? 1 : 0,
                    'workday_type_id' => $workday_type->id ?? null,
                    'contract_type_id' => $contract_type->id ?? null,
                    'department' => $row['departamento'],
                    'job' => $row['puesto'],
                    'job_risk_classe_id' => $job_risk_classe->id ?? null,
                    'frequency_payment_id' => $frequency_payment->id ?? null,
                    'bank_id' => $bank->id ?? null,
                    'bank_account' => $row['cuenta_bancaria'],
                    'base_salary' => (double)$row['salario_base_cotizacion'],
                    'sdi' => (double)$row['salario_diario_integrado'],
                    'state_id' => $state->id ?? null,
                    'country_id' => $country->id ?? null,
                    'status' => 1,
                    'company_id' => $company->id,
                    'employee_category_id' => $employee_category->id ?? null,
                    'tax_regimen_id' => $tax_regimen->id ?? null,
                    'postcode' => $row['cp'],
                ]);
            }
        }

        return true;
    }
}
