<?php

namespace App\Imports;

use App\Helpers\Helper;
use App\Models\Catalogs\Tax;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class PayrollAssimilatedTemplateBeforeImportImport implements ToCollection, WithHeadingRow
{
    /**
     * @param Collection $rows
     * @return bool
     * @throws \Exception
     */
    public function collection(Collection $rows)
    {
        //Limpieza de datos
        $rows = Helper::clearArrayImport($rows);

        //Importar datos
        $this->total_payrolls = 0;
        $this->total_amount_assimilated_payrolls = 0;
        $this->total_amount_isr_payrolls = 0;

        //Importar datos
        foreach ($rows as $row) {
            if (!empty($row['curp'])) {
                $this->total_payrolls++;
                $this->total_amount_assimilated_payrolls += (double) $row['importe_asimilados'];
                $this->total_amount_isr_payrolls += (double) $row['importe_isr'];
            }
        }
    }
}
