<?php

namespace App\Imports;

use App\Helpers\Helper;
use App\Models\Catalogs\Tax;
use App\Models\Catalogs\Deduction;
use Illuminate\Support\Collection;
use App\Models\Catalogs\Perception;
use App\Models\Catalogs\DisabilityType;
use App\Models\Catalogs\OtherPaymentType;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class PayrollsTemplateBeforeImportImport implements ToCollection, WithHeadingRow
{
    public $total_payrolls = 0;
    public $total_amount_payrolls = 0;
    public $subtotal_amount_payrolls = 0;
    public $total_amount_isr_payrolls = 0;
    public $total_amount_discount_payrolls = 0;

    /**
     * @param Collection $rows
     * @return bool
     * @throws \Exception
     */
    public function collection(Collection $rows)
    {
        //Limpieza de datos
        $rows = Helper::clearArrayImport($rows);

        //Importar datos
        $this->total_payrolls = 0;
        $this->total_amount_payrolls = 0;
        $this->subtotal_amount_payrolls = 0;
        $this->total_amount_isr_payrolls = 0;
        $this->total_amount_discount_payrolls = 0;

        //Importar datos
        foreach ($rows as $row) {
            if (!empty($row['curp'])) {
                $keys = array_keys($row->toArray());

                //Arreglo de percepciones, deducciones y otros pagos
                $keys_tmp = $keys;
                $keys_tmp = array_slice($keys_tmp, 6, count($keys_tmp) - 1);

                //#numero de recibos
                $this->total_payrolls++;

                //
                for ($i = 0; $i < count($keys_tmp); $i++) {
                    $text = explode('_', $keys_tmp[$i]);
                    $code = $text[0];
                    $type = $text[count($text) - 2];
                    $id = end($text);

                    //Valida que este con la nueva plantilla
                    if(!in_array($type, ['p','d','o']) || !is_numeric($id)){
                        //throw new \Exception(__('base/payroll.error_new_template'));
                    }

                    //Percepciones
                    if($type == 'p'){
                        $this->subtotal_amount_payrolls += (double) $row[$keys_tmp[$i]]; //Gravado
                        $i++;
                        if($code == '019'){
                            $i += 9;
                        }
                    }

                    //Deducciones
                    if($type == 'd'){
                        if (in_array($code, ['002', '101']))
                            $this->total_amount_isr_payrolls += (double)$row[$keys_tmp[$i]];
                        else
                            $this->total_amount_discount_payrolls += (double)$row[$keys_tmp[$i]];
                    }

                    //Otros pagos
                    if($type == 'o'){
                        $this->subtotal_amount_payrolls += (double)$row[$keys_tmp[$i]];
                        if($code == '002'){
                            $i++;
                        }
                    }
                }
            }
        }

        $this->total_amount_payrolls = $this->subtotal_amount_payrolls - $this->total_amount_isr_payrolls - $this->total_amount_discount_payrolls;
    }
}
