<?php

namespace App\Imports;

use App\Helpers\Helper;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class ProductTemplateBeforeImportImport implements ToCollection, WithHeadingRow
{

    /**
     * @param Collection $rows
     * @return mixed
     * @throws \Exception
     */
    public function collection(Collection $rows)
    {
        //Limpieza de datos
        $rows = Helper::clearArrayImport($rows);

        //Importar datos
        $this->total_products = 0;
        foreach ($rows as $row) {
            if (!empty($row['nombre']) && !empty($row['descripcion'])) {
                $this->total_products++;
            }
        }
    }
}
