<?php

namespace App\Jobs;

use SoapClient;
use App\Helpers\Helper;
use App\Models\Auth\User;
use App\Models\Base\Folio;
use App\Models\Base\Setting;
use Hyn\Tenancy\Environment;
use Illuminate\Http\Request;
use Illuminate\Bus\Queueable;
use Hyn\Tenancy\Models\Website;
use App\Models\Shop\ShopProduct;
use Hyn\Tenancy\Models\Hostname;
use App\Mail\SendAccessFactura16;
use App\Models\Catalogs\Currency;
use App\Models\System\SysCustomer;
use App\Mail\EmailVerifiedFactura16;
use App\Models\System\SysSalesOrder;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use GuzzleHttp\Exception\ClientException;
use GuzzleHttp\Exception\ServerException;
use GuzzleHttp\Exception\ConnectException;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use App\Mail\SendSysCustomerAccessFactura16;
use Hyn\Tenancy\Contracts\Repositories\WebsiteRepository;
use Hyn\Tenancy\Contracts\Repositories\HostnameRepository;

class CreateTenantJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $request;
    protected $sys_customer;
    protected $user;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($request, SysCustomer $sys_customer, $user = null)
    {
        $this->request = $request;
        $this->sys_customer = $sys_customer;
        $this->user = $user;
    }

    /**
     * Execute the job.
     *
     * @throws \Exception
     */
    public function handle()
    {
        //Variables
        $request = (object)$this->request;
        $sys_customer = $this->sys_customer;

        //Validacion para hosting compartido
        if(config('app.shared_hosting')){
            /*$website = new Website();
            $website->uuid = $request->db_shared_hosting;
            $website->save();*/
        }else{
            //Crear sitio, crea la BD
            $website = new Website();
            app(WebsiteRepository::class)->create($website);
        }

        //Crear hostname y asocia a sito
        /*$hostname = new Hostname();
        $hostname->fqdn = $sys_customer->fqdn;
        app(HostnameRepository::class)->attach($hostname, $website);*/

        //Actualizamos sys_customer con el sitio y hostname
        $sys_customer->hostname_id = null;
        $sys_customer->website_id = $website->id;
        $sys_customer->save();

        //Crear archivo *.conf para nginx asociado al hostname
        /*$path_nginx_vhost = array_get(config('webserver.nginx', []), 'paths.vhost-files', storage_path());
        if (is_array($path_nginx_vhost)) {
            $path_nginx_vhost = $path_nginx_vhost[0] . '/';
        }
        $content = view('layouts.partials.system.nginx_block_server', [
            'config' => config('webserver.nginx', []),
            'website' => $website,
            'hostname' => $hostname,
            'media' => '',
        ])->render();
        \File::put($path_nginx_vhost . $website->uuid . '.conf', $content);*/

        //Consumir API de Godaddy para crear subdominio
        /*if(!empty(config('app.godaddy_api_key'))) {
            try {
                $client = new \GuzzleHttp\Client();
                $record = [
                    'type' => 'A',
                    'name' => $sys_customer->record,
                    'data' => config('app.godaddy_records_a_data'),
                    'ttl' => 600,
                ];
                $url = 'https://api.godaddy.com/v1/domains/' . $sys_customer->domain . '/records/';
                $response = $client->patch($url, [
                    'headers' => [
                        'Accept' => 'application/json',
                        'Authorization' => 'sso-key ' . config('app.godaddy_api_key') . ':' . config('app.godaddy_api_secret'),
                        'Content-Type' => 'application/json',
                    ],
                    'body' => '[' . json_encode($record) . ']',
                ]);
                //OK Code: 200
            } catch (ClientException $e) {
                $result = \GuzzleHttp\json_decode($e->getResponse()->getBody()->getContents());
                $error = !empty($result->code) ? $result->code . ': ' . $result->message : 'Error';
                throw new \Exception($error);
            } catch (ServerException $e) {
                throw $e;
            } catch (ConnectException $e) {
                throw $e;
            }
        }*/

        //Reiniciar nginx

        //Crear usuario asociado al inquilino
        $password = Crypt::decryptString($sys_customer->password);
        $user = null;
        if(empty($this->user)){
            $user = User::create([
                'name' => $sys_customer->name_user,
                'email' => $sys_customer->email,
                'password' => bcrypt($password),
                'avatar' => '',
                'sort_order' => 0,
                'status' => 1,
                'sys_customer_id' => $sys_customer->id,
            ]);
            $user->email_verified_at = \Date::now();
            $user->save();
        }else{
            $user = $this->user;
            $user->sys_customer_id = $sys_customer->id;
            $user->save();
        }

        //Asigna usuario superadmin
        /*$user_root = \App\Models\Auth\User::where('email', '=', 'sksistemas@hotmail.com')->get()->first();
        $user_root->superadmin = 1;
        $user_root->save();*/

        //Cambiamos entorno al del inquilino creado
        app(Environment::class)->tenant($website);

        //Asigna PAC default
        $pac = \App\Models\Base\Pac::where('code', '=', config('app.pac_code'))->get()->first();
        if(!empty($pac)) {
            $setting = Setting::where('key','=','default_pac_id')->get()->first();
            $setting->value = $pac->id;
            $setting->save();
            if(!Helper::testEnvironment() && !empty(config('app.pac_name'))) { //Si esta en produccion cambia el nombre
                $pac->name = config('app.pac_name');
            }
            $pac->username = config('app.pac_key');
            $pac->password = Crypt::encryptString(config('app.pac_secret'));
            $pac->team_id = config('app.pac_team_id');
            $pac->token = config('app.pac_token');
            $pac->save();
        }

        //Actualiza datos de la empresa
        $company = Helper::defaultCompany();

        //Crea directorios
        if(config('app.shared_hosting')){
            /*$taxid = $sys_customer->taxid;
            $path = $sys_customer->taxid;
            if(!\Storage::exists($path)) {
                \Storage::makeDirectory($path, 0777, true); //creates directory
            }
            //Usuarios
            $path_user_avatars = $taxid .'/'. \App\Models\Auth\User::PATH_AVATARS;
            if(!\Storage::exists($path_user_avatars)) {
                \Storage::makeDirectory($path_user_avatars, 0777, true); //creates directory
            }
            //Empresas
            $path_company_images = $taxid .'/'.\App\Models\Base\Company::PATH_IMAGES;
            if(!\Storage::exists($path_company_images)) {
                \Storage::makeDirectory($path_company_images, 0777, true);
            }*/
        }else{
            //Renombra directorio del RFC
            //\Storage::move($company->taxid, $sys_customer->taxid);
        }

        //Actualiza datos de la empresa
        $company->name = $sys_customer->name;
        $company->taxid = $sys_customer->taxid;
        $company->email = $sys_customer->email;
        $company->phone = $sys_customer->phone;
        $company->save();

        //Solo Finkok
        //Crear cliente para finkok de timbrado bajo demanda
        if(preg_match('/finkok/i', config('app.pac_code')) && !empty($pac)){

            $client = new SoapClient(str_replace('cancel','registration',$pac->ws_url_cancel));
            $params = [
                'reseller_username' => $pac->username,
                'reseller_password' => Crypt::decryptString($pac->password),
                'taxpayer_id' => $company->taxid,
                'type_user' => 'O',
            ];
            $response = $client->__soapCall('add', ['parameters' => $params]);
        }

        //
        $available_folio = 0;
        $is_distributor = false;
        if(!empty($sys_customer->distributor)) {
            $distributor = $sys_customer->distributor;
            $available_folio = $distributor->available_folio;
            $is_distributor = false;
        }

        //Folios asignados manualmente
        if(!empty($request->product) && !empty($request->quantity_folio) && !empty($request->expiry_date)){
            if(!$is_distributor || ($is_distributor && $available_folio >= $request->quantity_folio)) { //valida que tenga folios el distribuidor para asignar
                //Otros datos
                $currency = Currency::where('code','=','MXN')->get()->first();

                $folio_pre = Folio::create([
                    'created_uid' => \Auth::user()->id ?? null,
                    'updated_uid' => \Auth::user()->id ?? null,
                    'name' => 'XXX' . random_int(1000, 9999),
                    'payment_platform' => __('base/folio.text_folio_assignments'),
                    'product' => $request->product,
                    'currency_id' => !empty($currency) ? $currency->id : null,
                    'currency_value' => !empty($currency) ? $currency->rate : null,
                    'quantity' => 1,
                    'price_unit' => $request->amount_total,
                    'price_reduce' => $request->amount_total,
                    'amount_untaxed' => $request->amount_total,
                    'amount_total' => $request->amount_total,
                    'quantity_folio' => $request->quantity_folio,
                    'available_folio' => $request->quantity_folio,
                    'expiry_date' => Helper::convertDateToSql($request->expiry_date), //Validos solo por 30 dias
                    'status' => Folio::ACTIVE
                ]);
                $folio_pre->name = 'CFL' . $folio_pre->id; //Actualizamos el folio
                $folio_pre->save();

                $available_folio -= $request->quantity_folio;
            }
        }

        //Paquete de folios comprados fuera de la plataforma
        if(!empty($request->shop_product_id)){

            //Otros datos
            $shop_product = ShopProduct::findOrFail($request->shop_product_id);
            $currency = Currency::where('code','=','MXN')->get()->first();

            //Calculo de impuestos
            $amount_untaxed = $shop_product->price;
            $amount_tax = 0;
            $amount_tax_ret = 0;
            if ($shop_product->taxes) {
                foreach ($shop_product->taxes as $result2) {
                    $tmp = 0;
                    if ($result2->factor == 'Tasa') {
                        $tmp = $amount_untaxed * $result2->rate / 100;
                    } elseif ($result2->factor == 'Cuota') {
                        $tmp = $result2->rate;
                    }
                    $tmp = round($tmp, 2);
                    if ($tmp < 0) { //Retenciones
                        $amount_tax_ret += $tmp;
                    } else { //Traslados
                        $amount_tax += $tmp;
                    }
                }
            }

            if(!$is_distributor || ($is_distributor && $available_folio >= $shop_product->quantity_folio)) { //valida que tenga folios el distribuidor para asignar
                $folio_paq = Folio::create([
                    'created_uid' => \Auth::user()->id ?? null,
                    'updated_uid' => \Auth::user()->id ?? null,
                    'name' => 'XXX' . random_int(1000, 9999),
                    'taxid' => $company->taxid,
                    'product' => $shop_product->description,
                    'product_code' => $shop_product->code,
                    'currency_id' => !empty($currency) ? $currency->id : null,
                    'currency_value' => !empty($currency) ? $currency->rate : null,
                    'quantity' => 1,
                    'price_unit' => $shop_product->price,
                    'price_reduce' => $shop_product->price,
                    'amount_untaxed' => $amount_untaxed,
                    'amount_tax' => $amount_tax,
                    'amount_tax_ret' => $amount_tax_ret,
                    'amount_total' => $amount_untaxed + $amount_tax + $amount_tax_ret,
                    'quantity_folio' => $shop_product->quantity_folio,
                    'available_folio' => $shop_product->quantity_folio,
                    'expiry_date' => \Date::now()->addDays(30), //Validos solo por 30 dias
                    'activation_date' => \Date::now(),
                    'status' => Folio::ACTIVE
                ]);
                $folio_paq->name = 'CFL' . $folio_paq->id; //Actualizamos el folio
                $folio_paq->save();

                $available_folio -= $shop_product->quantity_folio;
            }
        }

        //Retornamos a entorno default
        if(\Auth::user()->id ?? null){
            app(Environment::class)->tenant(\Auth::user()->sysCustomer->website ?? null);
        }

        //Pedido Folios asignados manualmente
        if(!empty($request->product) && !empty($request->quantity_folio) && !empty($request->expiry_date) && !empty($folio_pre)){
            //Guardamos en pedidos del sistema
            $folio = $folio_pre;
            $sys_sales_order = SysSalesOrder::create([
                'created_uid' => \Auth::user()->id ?? null,
                'updated_uid' => \Auth::user()->id ?? null,
                'name' => 'XXX' . random_int(1000, 9999),
                'sys_customer_id' => !empty($sys_customer) ? $sys_customer->id : null,
                'currency_id' => $folio->currency_id,
                'currency_value' => $folio->currency_value,
                'product' => $folio->product,
                'quantity' => $folio->quantity,
                'price_unit' => $folio->price_unit,
                'price_reduce' => $folio->price_reduce,
                'amount_untaxed' => $folio->amount_untaxed,
                'amount_total' => $folio->amount_total,
                'folio_id' => $folio->id,
                'sys_customer_folio' => $folio->name,
                'quantity_folio' => $folio->quantity_folio,
                'status' => SysSalesOrder::ACTIVE
            ]);
            $sys_sales_order->name = 'PV'.$sys_sales_order->id; //Actualizamos el folio
            $sys_sales_order->save();

            //Descuenta de los folios del distribuidor
            if(!empty($sys_customer->distributor)) {
                $distributor = $sys_customer->distributor;
                $distributor->available_folio -= $sys_sales_order->quantity_folio;
                $distributor->save();
            }
        }

        //Pedido Paquete de folios comprados fuera de la plataforma
        if(!empty($request->shop_product_id) && !empty($folio_paq)){
            //Guardamos en pedidos del sistema
            $folio = $folio_paq;
            $sys_sales_order = SysSalesOrder::create([
                'created_uid' => \Auth::user()->id ?? null,
                'updated_uid' => \Auth::user()->id ?? null,
                'name' => 'XXX' . random_int(1000, 9999),
                'sys_customer_id' => !empty($sys_customer) ? $sys_customer->id : null,
                'currency_id' => $folio->currency_id,
                'currency_value' => $folio->currency_value,
                'product' => $folio->product,
                'product_code' => $folio->product_code,
                'quantity' => $folio->quantity,
                'price_unit' => $folio->price_unit,
                'price_reduce' => $folio->price_reduce,
                'amount_untaxed' => $folio->amount_untaxed,
                'amount_tax' => $folio->amount_tax,
                'amount_tax_ret' => $folio->amount_tax_ret,
                'amount_total' => $folio->amount_total,
                'folio_id' => $folio->id,
                'sys_customer_folio' => $folio->name,
                'quantity_folio' => $folio->quantity_folio,
                'status' => SysSalesOrder::ACTIVE
            ]);
            $sys_sales_order->name = 'PV'.$sys_sales_order->id; //Actualizamos el folio
            $sys_sales_order->save();

            //Descuenta de los folios del distribuidor
            if(!empty($sys_customer->distributor)) {
                $distributor = $sys_customer->distributor;
                $distributor->available_folio -= $sys_sales_order->quantity_folio;
                $distributor->save();
            }
        }

        //Envio de accesos a usuario
        if(!empty($user->email_verified_token)){
            try {
                \Mail::to($user->email)->send(new EmailVerifiedFactura16($user));
            }catch(\Exception $e){
                flash(__('system/sys_customer.error_notification_email2') . '<br>' .$e->getMessage())->error();
            }
        }

        try {
            $tmp = [];
            \Mail::to($sys_customer->email)->send(new SendSysCustomerAccessFactura16($sys_customer, $password));
            if (!empty(config('app.mail_tenant_alert', ''))) {
                $tmp[] = config('app.mail_tenant_alert', '');
                if (!empty($sys_customer) && !empty($sys_customer->distributor->email)) {
                    $tmp[] = $sys_customer->distributor->email;
                }
                \Mail::to($tmp)->send(new SendSysCustomerAccessFactura16($sys_customer, $password));
            }
        }catch(\Exception $e){
            flash(__('system/sys_customer.error_notification_email') . '<br>' .$e->getMessage())->error();
        }

        return $user;
    }
}
