<?php

namespace App\Mail;

use App\Helpers\Helper;
use App\Models\Base\Company;
use App\Models\Base\Folio;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendActiveFolios extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * @var CustomerInvoice
     */
    public $folio;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(Folio $folio)
    {
        $this->folio = $folio;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $message = $this->subject(__('base/folio.text_mail_subject'))
            ->markdown('emails.send_active_folios');

        return $message;
    }
}
