<?php

namespace App\Mail;

use App\Helpers\Helper;
use App\Models\Base\Company;
use App\Models\Base\Folio;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendCartSuccess extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * @var CustomerInvoice
     */
    public $folio;

    /**
     * @var pdf
     */
    private $pdf;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(Folio $folio, $pdf)
    {
        $this->folio = $folio;
        $this->pdf = $pdf;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $message = $this->subject(__('shop/cart.text_mail_subject'))
            ->markdown('emails.send_cart_success');

        //Valida si se envia el PDF
        if (!empty($this->pdf)) {
            $message->attachData($this->pdf,
                $this->folio->name . '.pdf', [
                    'mime' => 'application/pdf',
                ]);
        }

        return $message;
    }
}
