<?php

namespace App\Mail;

use App\Helpers\Helper;
use App\Models\Base\Company;
use App\Models\Sales\CustomerInvoice;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendCustomerInvoice extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * @var CustomerInvoice
     */
    public $customer_invoice;

    /**
     * @var custom_message
     */
    public $custom_message;

    /**
     * @var pdf
     */
    private $pdf;

    /**
     * @var file_xml_pac
     */
    private $file_xml_pac;

    private $reply;


    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(CustomerInvoice $customer_invoice,$subject,$custom_message,$pdf,$file_xml_pac, $reply = [])
    {
        $this->customer_invoice = $customer_invoice;
        $this->subject = $subject; //incluido porr default
        $this->custom_message = $custom_message;
        $this->pdf = $pdf;
        $this->file_xml_pac = $file_xml_pac;
        $this->reply = $reply;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $message = $this->markdown('emails.send_customer_invoice');

        //Valida si se envia el PDF
        if(!empty($this->pdf)){
            $message->attachData($this->pdf,
            str_replace('/','',$this->customer_invoice->name) . '.pdf', [
                    'mime' => 'application/pdf',
                ]);
        }
        //Valida si existe y adjunta el XML
        if(!empty($this->file_xml_pac) && $this->customer_invoice->status != CustomerInvoice::DRAFT){
            if(\Storage::exists($this->file_xml_pac)) {
                $message->attach(\Storage::path($this->file_xml_pac), [
                    'as' => str_replace('/','',$this->customer_invoice->name) . '.xml'
                ]);
            }
        }

        if(!empty($this->reply)){
            $message->replyTo($this->reply);
        }

        return $message;
    }
}
