<?php

namespace App\Mail;

use App\Helpers\Helper;
use App\Models\Base\Company;
use App\Models\Sales\CustomerQuotation;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendCustomerQuotation extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * @var CustomerQuotation
     */
    public $customer_quotation;

    /**
     * @var custom_message
     */
    public $custom_message;

    /**
     * @var pdf
     */
    private $pdf;

    private $reply;


    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(CustomerQuotation $customer_quotation,$subject,$custom_message,$pdf, $reply = [])
    {
        $this->customer_quotation = $customer_quotation;
        $this->subject = $subject;
        $this->custom_message = $custom_message;
        $this->pdf = $pdf;
        $this->reply = $reply;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $message = $this->markdown('emails.send_customer_quotation');

        //Valida si se envia el PDF
        if(!empty($this->pdf)){
            $message->attachData($this->pdf,
            str_replace('/','',$this->customer_quotation->name) . '.pdf', [
                    'mime' => 'application/pdf',
                ]);
        }

        if(!empty($this->reply)){
            $message->replyTo($this->reply);
        }

        return $message;
    }
}
