<?php

namespace App\Mail;

use App\Helpers\Helper;
use App\Models\Base\Company;
use App\Models\Sales\CustomerRemission;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendCustomerRemission extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * @var CustomerRemission
     */
    public $customer_remission;

    /**
     * @var custom_message
     */
    public $custom_message;

    /**
     * @var pdf
     */
    private $pdf;

    private $reply;


    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(CustomerRemission $customer_remission,$subject,$custom_message,$pdf, $reply = [])
    {
        $this->customer_remission = $customer_remission;
        $this->subject = $subject;
        $this->custom_message = $custom_message;
        $this->pdf = $pdf;
        $this->reply = $reply;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $message = $this->markdown('emails.send_customer_remission');

        //Valida si se envia el PDF
        if(!empty($this->pdf)){
            $message->attachData($this->pdf,
            str_replace('/','',$this->customer_remission->name) . '.pdf', [
                    'mime' => 'application/pdf',
                ]);
        }

        if(!empty($this->reply)){
            $message->replyTo($this->reply);
        }

        return $message;
    }
}
