<?php

namespace App\Mail;

use App\Helpers\Helper;
use App\Models\Base\Company;
use App\Models\Base\EmployeePayroll;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendEmployeePayroll extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * @var EmployeePayroll
     */
    public $employee_payroll;

    /**
     * @var custom_message
     */
    public $custom_message;

    /**
     * @var pdf
     */
    private $pdf;

    /**
     * @var file_xml_pac
     */
    private $file_xml_pac;

    private $reply;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(EmployeePayroll $employee_payroll,$subject,$custom_message,$pdf,$file_xml_pac, $reply = [])
    {
        $this->employee_payroll = $employee_payroll;
        $this->subject = $subject; //incluido porr default
        $this->custom_message = $custom_message;
        $this->pdf = $pdf;
        $this->file_xml_pac = $file_xml_pac;
        $this->reply = $reply;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $message = $this->markdown('emails.send_employee_payroll');

        //Valida si se envia el PDF
        if(!empty($this->pdf)){
            $message->attachData($this->pdf,
            str_replace('/','',$this->employee_payroll->name) . '.pdf', [
                    'mime' => 'application/pdf',
                ]);
        }
        //Valida si existe y adjunta el XML
        if(!empty($this->file_xml_pac)){
            if(\Storage::exists($this->file_xml_pac)) {
                $message->attach(\Storage::path($this->file_xml_pac), [
                    'as' => str_replace('/','',$this->employee_payroll->name) . '.xml'
                ]);
            }
        }

        if(!empty($this->reply)){
            $message->replyTo($this->reply);
        }

        return $message;
    }
}
