<?php

namespace App\Mail;

use App\Models\System\SysCustomer;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendSysCustomerAccessFactura16 extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * @var SysCustomer
     */
    public $sys_customer;

    /**
     * @var password
     */
    public $password;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(SysCustomer $sys_customer,$password)
    {
        $this->sys_customer = $sys_customer;
        $this->password = $password;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject(__('system/sys_customer.text_mail_factura_16_subject'))
            ->markdown('emails.send_sys_customer_access_factura_16');
    }
}
