<?php

namespace App\Models\Base;

use App\Helpers\Helper;
use Kyslik\ColumnSortable\Sortable;
use Illuminate\Database\Eloquent\Model;
use Hyn\Tenancy\Traits\UsesSystemConnection;

class Announcement extends Model
{
    Use Sortable,UsesSystemConnection;

    protected $table = 'announcements';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid', 'updated_uid', 'sys_customer_id', 'date_start', 'date_end', 'type', 'description', 'status',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['description', 'type', 'description', 'date_start', 'date_end', 'status'];

    /**
     * Funcion para busqueda general
     *
     * @param $query
     * @param array $input
     * @return mixed
     */
    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('description', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('type', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        if (!empty($input['filter_date_from'])) {
            $query->whereDate('date_start', '<=', Helper::convertDateToSql($input['filter_date_from']));
        }
        if (!empty($input['filter_date_to'])) {
            $query->whereDate('date_end', '>=', Helper::convertDateToSql($input['filter_date_to']));
        }

        return $query;
    }

    /**
     * Solo registros activos
     *
     * @param $query
     * @return mixed
     */
    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function getTypeSAttribute()
    {
        $types = __('general.text_announcement_types');
        return !empty($types[$this->type]) ? $types[$this->type] : '';
    }
}
