<?php

namespace App\Models\Base;

use App\Models\Catalogs\Currency;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\Base\BankMove
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string|null $key
 * @property string|null $date
 * @property string|null $reference
 * @property float $amount
 * @property int|null $currency_id
 * @property int|null $company_id
 * @property string|null $file_template
 * @property int|null $bank_reconciliation_line_id
 * @property bool $status
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\BankMoveReconciled[] $bankMoveReconcileds
 * @property-read \App\Models\Base\Company|null $company
 * @property-read \App\Models\Catalogs\Currency|null $currency
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMove newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMove newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMove query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMove sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMove whereAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMove whereBankReconciliationLineId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMove whereCompanyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMove whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMove whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMove whereCurrencyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMove whereDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMove whereFileTemplate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMove whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMove whereKey($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMove whereReference($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMove whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMove whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMove whereUpdatedUid($value)
 * @mixin \Eloquent
 * @property bool $conciled
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMove whereConciled($value)
 */
class BankMove extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'bank_moves';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'key',
        'date',
        'reference',
        'amount',
        'currency_id',
        'company_id',
        'file_template',
        'bank_reconciliation_line_id',
        'status',
        'conciled'
    ];

    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function bankMoveReconcileds()
    {
        return $this->hasMany(BankMoveReconciled::class);
    }
}
