<?php

namespace App\Models\Base;

use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\Base\BankMoveReconciled
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int|null $bank_move_id
 * @property int|null $reconciled_id
 * @property string|null $key
 * @property float $amount_reconciled
 * @property int|null $bank_reconciliation_line_id
 * @property int $sort_order
 * @property bool $status
 * @property-read \App\Models\Base\BankMove|null $bankMove
 * @property-read \App\Models\Base\CfdiDownload|null $reconciled
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveReconciled active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveReconciled filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveReconciled newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveReconciled newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveReconciled query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveReconciled sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveReconciled whereAmountReconciled($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveReconciled whereBankMoveId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveReconciled whereBankReconciliationLineId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveReconciled whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveReconciled whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveReconciled whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveReconciled whereKey($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveReconciled whereReconciledId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveReconciled whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveReconciled whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveReconciled whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveReconciled whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class BankMoveReconciled extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'bank_move_reconcileds';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'bank_move_id',
        'reconciled_id',
        'key',
        'amount_reconciled',
        'bank_reconciliation_line_id',
        'sort_order',
        'status',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['bank_move_id','reconciled_id','sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function bankMove()
    {
        return $this->belongsTo(BankMove::class);
    }

    public function reconciled()
    {
        return $this->belongsTo(CfdiDownload::class,'reconciled_id','id');
    }

    public function bankReconciliationLine()
    {
        return $this->belongsTo(BankReconciliationLine::class);
    }
}
